package com.digiwin.mobile.mobileuibot.agileData.sse.dto;


import com.digiwin.mobile.mobileuibot.agileData.sse.domain.AthenaMessageEvent;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: SunHong
 * @Date: 2024/9/13 10:16
 * @Description: 语义识别入参
 */
@Data
public class QuerySchemaReqDTO implements Serializable {

    /** 用户问句 */
    private String message;

    private String question;

    /** 是否开启多轮 */
    private Boolean multiDialogue;

    /** 调试输出解释器*/
    private Boolean explain;

    /** 时间戳调试*/
    private Boolean timeTrace;

    /** 多轮sessionId */
    private String sessionId;

    /** 目标id */
    private String targetId;

    /** 场景编号 */
    private String sceneCode;

    /** 1:param (sceneCode必传);2:pr-param；3:debug(sceneCode必传)；4:test(sceneCode必传) */
    private String debugMode;

    /** 指标id列表 可选 可以是多个指标，用于订阅和指标导正 */
    private List<String> metricIdList;

    /** 应用编码 */
    private String appCode;

    /** 应用版本号 */
    private String version;

    /** 当前数据流的模式，metric指标，dataFlow场景数据流 */
    private String method;

    /** 用户id */
    private String userId;

    /** 用户名称 */
    private String userName;

    /**
     * 娜娜融合 上下⽂组合消息
     */
    private String combinationMsg;

    /**
     * 助理编码
     */
    private String asaCode;

    /**
     * 是否关闭流式返回
     */
    private boolean closeStream;


    /** 应用版本号 */
    private String productVersion;


    /** 指标id列表 可选 可以是多个指标，用于订阅和指标导正 */
    private List<String> datasetIdList;

    private boolean probe;

    /**
     * 2.0 段落会话id
     */
    private String sectionId;

    /**
     * 2.0 段落每句的消息id
     */
    private String messageId4Ania;

    /**
     * 2.0 会话id
     */
    private String conversationId;

    private String appVersion;

    /**
     * 语义识别入参初始化
     * @param event 上下文
     * @return 语义识别入参
     */
    public static QuerySchemaReqDTO builderSchemaReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO querySchemaReqDTO = new QuerySchemaReqDTO();
        querySchemaReqDTO.setUserId(event.getUserId());
        querySchemaReqDTO.setUserName(event.getUserName());
        querySchemaReqDTO.setSessionId(event.getSessionId());
        querySchemaReqDTO.setMessage(event.getQuestion());
        querySchemaReqDTO.setAsaCode(event.getAsaCode());
        return querySchemaReqDTO;
    }

}