package com.digiwin.mobile.mobileuibot.agileData.sse.service;


import com.digiwin.mobile.mobileuibot.agileData.sse.api.SSEManagerService;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.SseEmitterCompletionCallbackComponent;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.SseEmitterErrorCallbackComponent;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.SseEmitterTimeOutCallbackComponent;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

/**
 * SSE管理服务
 */
@Service
public class SSEManagerServiceImpl implements SSEManagerService {

    /**
     * 构建SSE管道
     * @param sseBaseEvent
     * @return
     */
    @Override
    public SseEmitter generateSseEmitter(SSEBaseEvent sseBaseEvent) {
        SseEmitter sseEmitter = new SseEmitter(5 * 60 * 1000L);
        sseBaseEvent.setAniaEmitter(sseEmitter);
        sseEmitter.onTimeout(new SseEmitterTimeOutCallbackComponent(sseBaseEvent));
        sseEmitter.onError(new SseEmitterErrorCallbackComponent(sseBaseEvent));
        sseEmitter.onCompletion(new SseEmitterCompletionCallbackComponent(sseBaseEvent));
        return sseEmitter;
    }
}