package com.digiwin.mobile.mobileuibot.agileData.sse.service.impl.event;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.EventData;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.SseAniaEventEnum;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.SseScrumEventEnum;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.utils.SseEmitterUtils;
import lombok.extern.slf4j.Slf4j;
import okhttp3.sse.EventSource;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Slf4j
@Service
public class SSEOnEventAdtServiceImpl extends SSEOnEventService {

    /**
     * 处理从adt服务通过SSE流返回的各种事件
     * 根据事件类型（如分析、消息详情、完成、结果等）进行不同的处理
     * 当收到SCRUMBI_RESULT事件时，调用sseProcess()方法执行后续的数据处理逻辑
     * @param sseBaseEvent
     * @param eventSource
     * @param type
     * @param data
     */
    @Override
    public void onEvent(SSEBaseEvent sseBaseEvent, EventSource eventSource, String type, String data) {
        SseEmitter sseEmitter = sseBaseEvent.getAniaEmitter();
        JSONObject res = JSONObject.parseObject(data);
        String status = res.getString("status");
        log.info("type:{}", type);
        if (SseAniaEventEnum.CHAT_DONE.getEvent().equals(type)) {
            // this.sendEventDataMessage(SseAniaEventEnum.CHAT_COMPLETED.getEvent(), sseEmitter, new EventData.EventMessage());
            this.sendEventDataMessage(SseAniaEventEnum.CHAT_DONE.getEvent(), sseEmitter, new EventData.EventMessage());
        } else if (SseScrumEventEnum.SCRUMBI_RESULT.getEvent().equals(type)) {
            //发送流式消息
            SseEmitterUtils.sendAnswerDone(sseEmitter, true);
        } else if (SseScrumEventEnum.SCRUMBI_COMPLEATE.getEvent().equals(type)) {
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageCloseV2(
                    "tool_response", sseBaseEvent.getId(), status);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, eventMessage);
        } else if (SseScrumEventEnum.SCRUMBI_DONE.getEvent().equals(type)) {
            eventSource.cancel();
        } else {
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageV2(
                    res, sseBaseEvent.getId());
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
        }
    }
}