package com.digiwin.mobile.mobileuibot.agileData.sse.service.impl.event;


import com.digiwin.mobile.mobileuibot.agileData.sse.domain.EventData;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.utils.SseEmitterUtils;
import okhttp3.sse.EventSource;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.util.Objects;


public abstract class SSEOnEventService {

    public abstract void onEvent(SSEBaseEvent sseBaseEvent, EventSource eventSource, String type, String data);

    /**
     * 发送娜娜消息
     * @param sendEvent 发送事件名称
     * @param sseEmitter sse链接
     * @param eventMessage 发送消息体
     */
    public void sendEventDataMessage(String sendEvent, SseEmitter sseEmitter, EventData.EventMessage eventMessage) {
        EventData eventData = new EventData(sendEvent, eventMessage);
        if (Objects.nonNull(sseEmitter)) {
            SseEmitterUtils.send(sseEmitter, eventData);
        }
    }

}