package com.digiwin.mobile.mobileuibot.agileData.sse.service.impl.process;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.agileData.constant.AgileDataConstant;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.AthenaMessageEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.EventStreamClient;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.AdtChatQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.listener.SSEAdtListener;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class SSEProcessAdtServiceImpl implements SSEProcessService {

    @Autowired
    private SysEnvConfig sysEnvConfig;

    /**
     * 负责启动SSE连接,初始化并建立与ADT服务的SSE连接
     *
     * @param sseScrumListener
     * @param event
     * @param req
     * @param sseBaseEvent
     */
    @Override
    public void process(SSEAdtListener sseScrumListener, AthenaMessageEvent event, Map<String, Object> req, SSEBaseEvent sseBaseEvent) {
        String adtUrl = sysEnvConfig.getAdtUrl() + AgileDataConstant.ADT_SSE_URL;
        AdtChatQueryDTO chatReqDTO = JsonUtil.objectToJavaObject(req, AdtChatQueryDTO.class);
        EventStreamClient.executeSSE(event, adtUrl, sseScrumListener,
                JsonUtil.objectToJavaObject(chatReqDTO, JSONObject.class), sseBaseEvent);
    }
}