package com.digiwin.mobile.mobileuibot.agileData.sse.utils;

import okhttp3.OkHttpClient;

import java.net.Proxy;
import java.util.concurrent.TimeUnit;

import static com.digiwin.mobile.mobileuibot.agileData.sse.domain.EventStreamClient.connectionPool;

/**
 * sse客户端连接
 */
public class OkHttpUtil {

    private static volatile OkHttpClient okHttpClient;

    public static OkHttpClient getInstance() {

        if (okHttpClient == null) { //加同步安全
            synchronized (OkHttpClient.class) {
                if (okHttpClient == null) { //okhttp可以缓存数据....指定缓存路径
                    okHttpClient = new OkHttpClient.Builder()
                            .proxy(Proxy.NO_PROXY)
                            .connectionPool(connectionPool)
                            .connectTimeout(120, TimeUnit.SECONDS)//连接超时
                            .writeTimeout(120, TimeUnit.SECONDS)//写入超时
                            .readTimeout(120, TimeUnit.SECONDS)//读取超时
                            .pingInterval(5, TimeUnit.SECONDS)
                            .build();
                }
            }
        }
        return okHttpClient;
    }

}