package com.digiwin.mobile.mobileuibot.aiassistant;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.digiwin.mobile.mobileuibot.aiassistant.model.AdapterAudcUserTrack;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.AsaDispatchRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.MessageInfoRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.service.AdapterService;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcUserTrack;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: SunHong
 * @Date: 2024/2/29 9:31
 * @Description:
 */
@Api(value = "API - AdapterController", description = "asa路由")
@RestController
@RequestMapping("/asaAdapter")
@RequiredArgsConstructor
@Slf4j
@CrossOrigin(origins = "*")
public class AdapterController {

    private static final String PARAM_KEY = "paramKey";

    @Autowired
    private AdapterService adapterService;

    private static final Logger logger = LoggerFactory.getLogger(AdapterController.class);

    @GetMapping("/assistant/getAssistantDetail")
    @AdapterUrl(url = "/assistant/getAssistantDetail")
    @ApiOperation("查询小助手详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse getAssistantDetail(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }



    @GetMapping("/beginnerTutorial/getBeginnerTutorialMsg")
    @AdapterUrl(url = "/beginnerTutorial/getBeginnerTutorialMsg")
    @ApiOperation("查询随机话术")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
            paramType = "Header")})
    public ApiResponse getBeginnerTutorialMsg(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping("/beginnerTutorial/ignoreButton")
    @AdapterUrl(url = "/beginnerTutorial/ignoreButton")
    @ApiOperation("操作指引,忽略按钮")
    public ApiResponse ignoreButton(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/common/business/language/template")
    @AdapterUrl(url = "/common/business/language/template")
    @ApiOperation(value = "查询语言模版")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryLanguageTemplate(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/common/business/clean/corpus/cache")
    @AdapterUrl(url = "/common/business/clean/corpus/cache")
    @ApiOperation(value = "清空所有语料的缓存")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse cleanCorpusDataCache(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }


    @PostMapping("/dmc/upload")
    @AdapterUrl(url = "/dmc/upload")
    public ApiResponse dmcUpload(@RequestParam("file") MultipartFile file,@RequestParam Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,file,requestParam);
    }

    @PostMapping("/dmc/upload/picture/thumbnail")
    @AdapterUrl(url = "/dmc/upload/picture/thumbnail")
    @ApiOperation(value = "图片、缩略图")
    public ApiResponse uploadPictureThumbnail(@RequestParam("file") MultipartFile file,
                                              @RequestParam Map<String,Object> requestParam,HttpServletRequest httpRequest){
        checkContextToken(httpRequest);
        ApiResponse res =  adapterService.sendPost(httpRequest,file,requestParam);
        logger.debug("upload picture thumbnail is res:{} ",res);
        return res;
    }

    @PostMapping("/dmc/upload/voice")
    @AdapterUrl(url = "/dmc/upload/voice")
    @ApiOperation(value = "语音上传并异步转换文本通知")
    public ApiResponse uploadWavAndCovertText(@RequestParam("file") MultipartFile file,
                                              @RequestParam Map<String,Object> requestParam,HttpServletRequest httpRequest){
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,file,requestParam);
    }

    @GetMapping("/dmc/deleteFile")
    @AdapterUrl(url = "/dmc/deleteFile")
    public ApiResponse deleteFile(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }


    @PostMapping("/group/groupInitiateMatters")
    @AdapterUrl(url = "/group/groupInitiateMatters")
    @ApiOperation(value = "分组发起项目")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "sourceProjectId", value = "项目Id", required = true, dataType = "String",
                    paramType = "path"),
            @ApiImplicitParam(name = "groupInitiateMatters", value = "群组发起参数", required = true, dataType = "GroupInitiateMattersDto",
                    paramType = "body")
    })
    public ApiResponse groupInitiateMatters(@RequestBody MessageInfoRequest requestParam, HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping("/group/groupMattersAssociation")
    @AdapterUrl(url = "/group/groupMattersAssociation")
    @ApiOperation(value = "分组发起关联项目查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "projectId", value = "项目Id", required = true, dataType = "String",
                    paramType = "path")})
    public ApiResponse groupMattersAssociation(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping("/minuteOfMeeting/handMovement")
    @AdapterUrl(url = "/minuteOfMeeting/handMovement")
    @ApiOperation(value = "手动发起会议记录项目")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse handMovement(@RequestParam Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/minuteOfMeeting/minutes/submit")
    @AdapterUrl(url = "/minuteOfMeeting/minutes/submit")
    @ApiOperation(value = "会议纪要待办操作")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse minutesSubmit(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping("/minuteOfMeeting/minutes/query")
    @AdapterUrl(url = "/minuteOfMeeting/minutes/query")
    @ApiOperation(value = "会议纪要卡片查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse minutesQuery(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping("/minuteOfMeeting/minutes/confirm/query")
    @AdapterUrl(url = "/minuteOfMeeting/minutes/confirm/query")
    @ApiOperation(value = "会议纪要卡片查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse minutesConfirmQuery(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping("/minuteOfMeeting/minutes/data/save")
    @AdapterUrl(url = "/minuteOfMeeting/minutes/data/save")
    @ApiOperation(value = "会议纪要数据保存（精炼纪要+待办保存）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse saveMinutesData(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/minuteOfMeeting/voice/submit")
    @AdapterUrl(url = "/minuteOfMeeting/voice/submit")
    @ApiOperation(value = "会议记录录音保存")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse minutesVoiceSubmit(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/minuteOfMeeting/minutes/signUrge")
    @AdapterUrl(url = "/minuteOfMeeting/minutes/signUrge")
    @ApiOperation(value = "会议签到电话提醒")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse meetingSignUrge(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }


    @PostMapping("/message/conversation/receive")
    @AdapterUrl(url = "/message/conversation/receive")
    public ApiResponse imReceive(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }


    @PostMapping("/message/info")
    @AdapterUrl(url = "/message/info")
    @ApiOperation(value = "消息业务信息查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse messageStatus(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @ApiOperation(value = "B娜消息查询")
    @PostMapping("/message/athena/info")
    @AdapterUrl(url = "/message/athena/info")
    public ApiResponse messageAthenaStatus(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam.values());
    }

    @GetMapping("/message/getHistoricalMessage")
    @AdapterUrl(url = "/message/getHistoricalMessage")
    @ApiOperation(value = "获取自然语言中关联历史消息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse getHistoricalMessage(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }


    @GetMapping("/message/judgeTerminationMatters")
    @AdapterUrl(url = "/message/judgeTerminationMatters")
    @ApiOperation(value = "获取该消息是否可'终止事项'")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse judgeTerminationMatters(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }


    @PostMapping("/newRecordOverview/submit")
    @AdapterUrl(url = "/newRecordOverview/submit")
    @ApiOperation(value = "提交填写任务信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse submit(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/newRecordOverview/athena/submit")
    @AdapterUrl(url = "/newRecordOverview/athena/submit")
    @ApiOperation(value = "提交填写任务信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse athenaSubmit(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/newRecordOverview/submitedMessage")
    @AdapterUrl(url = "/newRecordOverview/submitedMessage")
    @ApiOperation(value = "查询协调场景他人已提交的数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse submitedMessage(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/newRecordOverview/getOngoingTask")
    @AdapterUrl(url = "/newRecordOverview/getOngoingTask")
    @ApiOperation(value = "获取待办的多任务信息(小舌头)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse getOngoingTask(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/newRecordOverview/getMyTaskInfo")
    @AdapterUrl(url = "/newRecordOverview/getMyTaskInfo")
    @ApiOperation(value = "获取我收到的任务卡片信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse getMyTaskInfo(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping("/newRecordOverview/distribute/work")
    @AdapterUrl(url = "/newRecordOverview/distribute/work")
    @ApiOperation(value = "重新派发任务卡")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    @Deprecated
    public ApiResponse newRecordDistributeWorkItem(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap){
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping("/newRecordOverview/save/feedbackInfo")
    @AdapterUrl(url = "/newRecordOverview/save/feedbackInfo")
    @ApiOperation(value = "保存用户反馈信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse saveFeedbackInfo(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/newRecordOverview/updateReadStatus")
    @AdapterUrl(url = "/newRecordOverview/updateReadStatus")
    @ApiOperation(value = "更新记录页项目及任务卡已读状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse updateReadStatus(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }


    @PostMapping("/newRecordOverview/queryTelephoneReminderInfo")
    @AdapterUrl(url = "/newRecordOverview/queryTelephoneReminderInfo")
    @ApiOperation(value = "获取聚合卡片中电话催办的详情信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse queryTelephoneReminderInfo(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }


    @PostMapping("/newRecordOverview/excuteTelephoneReminder")
    @AdapterUrl(url = "/newRecordOverview/excuteTelephoneReminder")
    @ApiOperation(value = "电话催办执行（批量和单个）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse excuteTelephoneReminder(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/project/end")
    @AdapterUrl(url = "/project/end")
    @ApiOperation(value = "项目结束回调")
    public ApiResponse projectCallback(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @AdapterUrl(url = "/project/collect/record")
    @PostMapping("/project/collect/record")
    @ApiOperation(value = "收集项目记录查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse projectRecord(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping("/project/generate/download/url")
    @AdapterUrl(url = "/project/generate/download/url")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse downloadProject(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping("/project/generate/detect/download/url")
    @AdapterUrl(url = "/project/generate/detect/download/url")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse downloadDetectProject(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping("/project/urge/query")
    @AdapterUrl(url = "/project/urge/query")
    @ApiOperation(value = "项目催办查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse getProjectUrge(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping("/project/urge/update")
    @AdapterUrl(url = "/project/urge/update")
    @ApiOperation(value = "项目催办设置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse saveProjectUrge(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/project/urge/update/effectiveStatus")
    @AdapterUrl(url = "/project/urge/update/effectiveStatus")
    @ApiOperation(value = "项目催办设置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse updateProjectUrgeStatus(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/project/list")
    @AdapterUrl(url = "/project/list")
    @ApiOperation(value = "获取我发起的项目集合")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse getMyInitiatedProjectList(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping("/project/list/query")
    @AdapterUrl(url = "/project/list/query")
    @ApiOperation(value = "获取我发起的项目集合单独查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse getMyInitiatedProject(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping("/project/query/info")
    @AdapterUrl(url = "/project/query/info")
    @ApiOperation(value = "获取我发起的项目信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse getProjectInfo(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping("/project/terminate")
    @AdapterUrl(url = "/project/terminate")
    @ApiOperation(value = "结束项目")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse terminate(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }


    @PostMapping("/card/task/read")
    @AdapterUrl(url = "/card/task/read")
    @ApiOperation(value = "卡片任务已读")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse taskCardRead(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam.get(PARAM_KEY));
    }

    @PostMapping("/card/task/athena/read")
    @AdapterUrl(url = "/card/task/athena/read")
    @ApiOperation(value = "卡片任务已读")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse athenaTaskCardRead(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam.get(PARAM_KEY));
    }

    @GetMapping("/card/task/distribute")
    @AdapterUrl(url = "/card/task/distribute")
    @ApiOperation(value = "重新派发任务卡")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse distributeWorkItem(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping("/card/task")
    @AdapterUrl(url = "/card/task")
    @ApiOperation(value = "获取卡片任务")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse getCard(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping("/card/task/athena/distribute")
    @AdapterUrl(url = "/card/task/athena/distribute")
    @ApiOperation(value = "重新派发任务卡")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse athenaDistributeWorkItem(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap){
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }


    @PostMapping("/user/immediate/phone/followup")
    @AdapterUrl(url = "/user/immediate/phone/followup")
    @ApiOperation(value = "一键电话催办", notes = "详情页")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
            paramType = "Header")})
    public ApiResponse immediatePhoneFollowUp(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping("/user/employee/department/data")
    @AdapterUrl(url = "/user/employee/department/data")
    @ApiOperation(value = "获取人员部门数据")
    public ApiResponse getEmployeeDepartmentData(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping("/user/department/data")
    @AdapterUrl(url = "/user/department/data")
    @ApiOperation(value = "获取人员部门数据")
    public ApiResponse getDepartmentData(HttpServletRequest httpRequest, @RequestParam MultiValueMap<String, Object> formDataMap) {
        long startTime = System.currentTimeMillis();
        checkContextToken(httpRequest);
        long endTime = System.currentTimeMillis();
        log.debug("AdapterController#getEmployeeDepartmentData#time:{}", startTime - endTime);
        return adapterService.sendGet(httpRequest, formDataMap);
    }

    @GetMapping("/user/global/urge")
    @AdapterUrl(url = "/user/global/urge")
    @ApiOperation(value = "查询用户全局催办规则")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true,
            dataType = "String", paramType = "Header")})
    public ApiResponse queryUserGlobalUrge(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping("/user/global/urge/update")
    @AdapterUrl(url = "/user/global/urge/update")
    @ApiOperation(value = "更新用户全局催办规则")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true,
            dataType = "String", paramType = "Header")})
    public ApiResponse update(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping(value = "/gp/form/param/notify_personnel")
    @AdapterUrl(url = "/gp/form/param/notify_personnel")
    @ApiOperation(value = "通知人员参数列表")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true,
            dataType = "String", paramType = "Header")})
    public ApiResponse queryNotifyPersonnelParam(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping(value = "/gp/form/param/business_client")
    @AdapterUrl(url = "/gp/form/param/business_client")
    @ApiOperation(value = "洽公对象（客户）")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true,
            dataType = "String", paramType = "Header")})
    public ApiResponse queryBusinessClientParam(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping(value = "/gp/form/param/city")
    @AdapterUrl(url = "/gp/form/param/city")
    @ApiOperation(value = "出发城市")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true,
            dataType = "String", paramType = "Header")})
    public ApiResponse queryDepartureCityParam(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/param/transportation")
    @AdapterUrl(url = "/gp/form/param/transportation")
    @ApiOperation(value = "交通工具")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true,
            dataType = "String", paramType = "Header")})
    public ApiResponse queryTransportationParam(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/status")
    @AdapterUrl(url = "/gp/form/status")
    @ApiOperation(value = "查询表单状态")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryFormStatus(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/approval/process/history")
    @AdapterUrl(url = "/gp/form/approval/process/history")
    @ApiOperation(value = "查询表单签核历程")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryFormApprovalProcessHistory(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/work/place")
    @AdapterUrl(url = "/gp/form/work/place")
    @ApiOperation(value = "工作地点参数列表")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryWorkPlace(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/reimbursement/window")
    @AdapterUrl(url = "/gp/form/reimbursement/window")
    @ApiOperation(value = "报销窗口")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryReimbursementWindow(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/lodging_fee/limit")
    @AdapterUrl(url = "/gp/form/lodging_fee/limit")
    @ApiOperation(value = "查询住宿限额")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryLodgingFeeLimit(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/business/single")
    @AdapterUrl(url = "/gp/form/business/single")
    @ApiOperation(value = "查询洽公单")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryBusinessSingleForm(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/project/list")
    @AdapterUrl(url = "/gp/form/project/list")
    @ApiOperation(value = "查询专案")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryProjectList(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/actual/reporting/user/list")
    @AdapterUrl(url = "/gp/form/actual/reporting/user/list")
    @ApiOperation(value = "查询实报实销人员列表")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryActualReportingUserList(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping("/consultTask/directly/specify")
    @AdapterUrl(url = "/consultTask/directly/specify")
    @ApiOperation(value = "协商任务直接指定")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse appointConsultData(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping(value = "/gp/meeting/form/info")
    @AdapterUrl(url = "/gp/meeting/form/info")
    @ApiOperation(value = "根据workItemId查询会议详情")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryGpMeetingDataByWorkItemId(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping("/assistant/getList")
    @ApiOperation("查询小助手列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header"),
            @ApiImplicitParam(name = "Accept-Language", value = "zh-TW/zh-CN", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse getList(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping("/assistant/downloadConferenceAssistantTemplate")
    @ApiOperation("下载会议小助手的人员导入模板")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header"),
            @ApiImplicitParam(name = "Accept-Language", value = "zh-TW/zh-CN", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse downloadConferenceAssistantTemplate(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping("/assistant/checkAndUploadConferenceAssistantTemplate")
    @ApiOperation("会议小助手上传Excel模板&校验接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header"),
            @ApiImplicitParam(name = "Accept-Language", value = "zh-TW/zh-CN", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse checkAndUploadConferenceAssistantTemplate(@RequestParam("file") MultipartFile file,
                                                                 @RequestParam Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping(value = "/gp/form/qia_gong/detailed")
    @ApiOperation(value = "查询洽公详细信息")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryQiaGongDetailedData(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping(value = "/gp/form/qia_gong/customer")
    @ApiOperation(value = "分页查询洽公对象")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryQiagongCompanyPage(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping(value = "/gp/form/whetherCanStartReimbursement/detail")
    @ApiOperation(value = "查询报销单详细信息")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse whetherCanStartReimbursementDetail(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/process/detailed")
    @ApiOperation(value = "查询表单任务详细信息")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryFormProcessDetailedData(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/user/job_type")
    @ApiOperation(value = "查询用户工种")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryUserType(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }
    @GetMapping(value = "/gp/form/expense/overdue/list")
    @ApiOperation(value = "查询GP逾期报销")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryExpenseOverdueList(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }
    @GetMapping(value = "/gp/form/checkQiaGongDays")
    @ApiOperation(value = "校验前端台湾洽公是否大于5个工作日")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse checkQiaGongDays(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/queryAssistantConfigList")
    @ApiOperation(value = "B娜查询有权限的助理")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryAssistantConfigList(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/queryAssistantList")
    @ApiOperation(value = "获取用户的权限的接口使用")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryAssistantList(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @GetMapping(value = "/gp/form/queryEocEmployeeDetailsData")
    @ApiOperation(value = "B娜出租车起始地查询")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryEocEmployeeDetailsData(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> formDataMap) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping(value = "/user/department/emp/data")
    @ApiOperation(value = "点击部门展开子级部门时，查询部门下的人员，返回所有的人员")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse getDepartmentEmpData(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping(value = "/user/department/emp/query")
    @ApiOperation(value = "根据工号和人员姓名查询人员列")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse getDepartmentEmpQuery(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @PostMapping("/minuteOfMeetingPending/minutes/submit")
    @ApiOperation(value = "会议纪要待办操作")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse minutesPendingSubmit(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }
    @GetMapping("/minuteOfMeetingPending/minutes/query")
    @ApiOperation(value = "会议纪要追踪待办卡片查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse minutesPengdingQuery(@RequestParam MultiValueMap<String,Object> formDataMap,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    @PostMapping("/minuteOfMeetingPending/minutes/data/save")
    @ApiOperation(value = "会议纪要数据保存（精炼纪要+待办保存）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse saveMinutesPendingData(@RequestBody Map<String,Object> requestParam,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping(value = "/common/business/queryAssistantScene")
    @AdapterUrl(url = "/common/business/queryAssistantScene")
    @ApiOperation(value = "查询助理场景")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse queryAssistantScene(HttpServletRequest httpRequest,@RequestParam MultiValueMap<String,Object> requestParam) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest, requestParam);
    }

    @PostMapping(value = "/common/business/refreshInspirationPhrase")
    @AdapterUrl(url = "/common/business/refreshInspirationPhrase")
    @ApiOperation(value = "更换话术")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse refreshInspirationPhrase(HttpServletRequest httpRequest,@RequestBody MultiValueMap<String,Object> requestParam) {
        checkContextToken(httpRequest);
        return adapterService.sendPost(httpRequest,requestParam);
    }

    @GetMapping("/assistant/saveUserLastAssistantMsgTime")
    @ApiOperation(value = "保存用户各助理最后发送消息的时间戳")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String",
                    paramType = "Header")})
    public ApiResponse saveUserLastAssistantMsgTime(@RequestParam MultiValueMap<String,Object> formDataMap,HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.sendGet(httpRequest,formDataMap);
    }

    public void checkContextToken(HttpServletRequest httpRequest){
        AppRequestContext.ContextEntity contextEntity = AppRequestContext.getContextEntity();
        String iamUserToken = httpRequest.getHeader("iamUserToken");
        if (StringUtils.isEmpty(iamUserToken)) {
            throw new ServiceException("iamUserToken is null");
        }
        contextEntity.setIamUserToken(iamUserToken);
    }


    @PostMapping("/dispatch")
    @ApiOperation(value = "接口转发")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse dispatch(@RequestBody AsaDispatchRequest asaDispatchRequest, HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return adapterService.dispatch(httpRequest, asaDispatchRequest);
    }


}
