package com.digiwin.mobile.mobileuibot.aiassistant;

import com.digiwin.mobile.mobileuibot.aiassistant.model.AiAssistantSkillTypeEnum;
import com.digiwin.mobile.mobileuibot.aiassistant.model.ExampleModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.QuestionsExampleModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.*;
import com.digiwin.mobile.mobileuibot.aiassistant.service.AiAssistantService;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.file.dto.AgileDataLiteUploadFileQueryDTO;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AgileDataCalculateConfigRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.ProcessMessageRequest;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoInformationModelQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoPageConfigProductBulletinQueryDTO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 敏捷数据
 *
 * @author xujinc
 * @date 2023/12/14 14:04
 */
@RestController
@RequestMapping("/mobile/aiassistant")
@Validated
public class AiAssistantController {

    @Autowired
    private AiAssistantService aiAssistantService;

    @Autowired
    private LocaleService localeService;


    @PostMapping("/getMessageInfo")
    public ApiResponse<Map<String, Object>> getMessageInfo(@RequestBody MessageInfoRequest messageInfoRequest) {
        Map<String, Object> messageInfoRespData;
        try {
            messageInfoRespData = aiAssistantService.getMessageInfo(messageInfoRequest);
        } catch (Exception e) {
            return ApiResponse.buildError(e.getMessage());
        }
        return ApiResponse.buildOK().setData(messageInfoRespData);
    }

    @PostMapping("/submitNewRecordOverview")
    public ApiResponse submitNewRecordOverview(@RequestBody NewRecordOverviewSubmitRequest newRecordOverviewSubmitRequest) {
        try {
            aiAssistantService.submitNewRecordOverview(newRecordOverviewSubmitRequest);
        } catch (Exception e) {
            return ApiResponse.buildError(e.getMessage());
        }
        return ApiResponse.buildOK();
    }

    @PostMapping("/taskDistribute")
    public ApiResponse taskDistribute(@RequestBody TaskDistributeRequest taskDistributeRequest) {
        String taskDistributeData;
        try {
            taskDistributeData = aiAssistantService.taskDistribute(taskDistributeRequest);
        } catch (Exception e) {
            return ApiResponse.buildError(e.getMessage());
        }
        return ApiResponse.buildOK().setData(taskDistributeData);
    }

    @Deprecated
    @PostMapping("/questions/example/first")
    public ApiResponse getQuestionExamplesFirstTime(@Validated @RequestBody AiAssistantQuestionExampleRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        AiAssistantSkillTypeEnum skillTypeEnum = AiAssistantSkillTypeEnum.getEnumByValue(apiRequest.getSkillType());
        switch (skillTypeEnum) {
            case AGILE_DATA:
                ExampleModel example = aiAssistantService.getExample(iamUserToken, locale);
                if (example == null) {
                    return ApiResponse.buildOK();
                }
                return ApiResponse.buildOK().setData(JsonUtil.objectToJavaObject(example, Map.class));
            case DOCUMENT_ASSISTANT:
                return ApiResponse.buildOK();
            case ADMINISTRATIVE_ASSISTANT:
                return ApiResponse.buildOK();
            default:
                return ApiResponse.buildOK();
        }
    }

    /**
     * 敏捷数据：查询指令集(娜娜页面:魔法棒)
     *
     * @param apiRequest
     * @return List<SceneIntentionModel>
     * @author yanfeng
     */
    @Deprecated
    @PostMapping("/questions/example/normal")
    public ApiResponse getQuestionExamplesInNormal(@Validated @RequestBody AiAssistantQuestionExampleRequest apiRequest) {
        // TODO 改从数据库获取
        String locale = apiRequest.getLocale();
        String tenantId = apiRequest.getTenantId();
        String exampleDataString;
        AiAssistantSkillTypeEnum skillTypeEnum = AiAssistantSkillTypeEnum.getEnumByValue(apiRequest.getSkillType());
        switch (skillTypeEnum) {
            case AGILE_DATA:
                List<QuestionsExampleModel> questionsExampleModels = this.aiAssistantService.querySceneIntentions(apiRequest.getIamUserToken(), locale);
                return ApiResponse.buildOK().setData(questionsExampleModels);
            case DOCUMENT_ASSISTANT:
                exampleDataString = this.aiAssistantService.getDocumentAssistantQuestionsExample(locale);
                return ApiResponse.buildOK().setData(JsonUtil.jsonStringToObject(exampleDataString, List.class));
            case ADMINISTRATIVE_ASSISTANT:
                exampleDataString = this.aiAssistantService.getAdministrativeQuestionsExample(locale);
                return ApiResponse.buildOK().setData(JsonUtil.jsonStringToObject(exampleDataString, List.class));
            default:
                return ApiResponse.buildOK();
        }
    }

    @PostMapping("getAssistantMockData")
    public ApiResponse getAssistantMockData(@RequestBody @Validated AssistantMockDataRequest assistantMockDataRequest) {
        List<String> assistantMockData = aiAssistantService.getAssistantMockData(assistantMockDataRequest);
        if (CollectionUtils.isEmpty(assistantMockData)) {
            return ApiResponse.buildOK(localeService.getLanguageValue(assistantMockDataRequest.getLocale(), "很抱歉，我暂时还不支持这类问题的回答"));
        }
        return ApiResponse.buildOK().setData(assistantMockData);
    }

    /**
     * 敏捷数据：数据订阅列表
     *
     * @param request
     * @return
     */
    @PostMapping("getDataSubscriptionList")
    public ApiResponse getDataSubscriptionList(@RequestBody @Validated DataSubscriptionRequest request) {
        return ApiResponse.buildOK().setData(aiAssistantService.getDataSubscriptionList(request));
    }

    /**
     * 敏捷数据：数据订阅新增/更新
     *
     * @param request
     * @return
     */
    @PostMapping("addOrUpdateDataSubscription")
    public ApiResponse addOrUpdateDataSubscription(@RequestBody @Validated DataSubscriptionRequest request) {
        Boolean b = aiAssistantService.addOrUpdateDataSubscription(request);
        //判断新增还是编辑可以根据ruleId是否为空(新增空)
        if (StringUtils.isBlank(request.getDataSubscriptionModel().getRuleId())) {
            if (b) {
                return ApiResponse.buildOK(localeService.getLanguageValue(request.getLocale(), "订阅成功！可在订阅管理中修改")).setData(true);
            } else {
                return ApiResponse.buildError(localeService.getLanguageValue(request.getLocale(), "订阅失败！请重试")).setData(false);
            }
        } else {
            if (!b) {
                return ApiResponse.buildError(localeService.getLanguageValue(request.getLocale(), "修改失败！请重试")).setData(false);
            }
        }
        return ApiResponse.buildOK("").setData(true);
    }

    /**
     * 敏捷数据：数据订阅删除
     *
     * @param request
     * @return
     */
    @PostMapping("removeDataSubscription")
    public ApiResponse removeDataSubscription(@RequestBody @Validated DataSubscriptionRequest request) {
        Boolean b = aiAssistantService.removeDataSubscription(request);
        if (!b) {
            return ApiResponse.buildError(localeService.getLanguageValue(request.getLocale(), "删除失败！请重试")).setData(false);
        }
        return ApiResponse.buildOK("").setData(true);
    }

    /**
     * 敏捷数据：数据订阅详情
     *
     * @param iamUserToken
     * @param ruleId
     * @return
     */
    @GetMapping("getDataSubscriptionInfo")
    public ApiResponse getDataSubscriptionInfo(String iamUserToken, String ruleId) {
        return ApiResponse.buildOK().setData(aiAssistantService.getDataSubscriptionInfo(iamUserToken, ruleId));
    }

    /**
     * 敏捷数据：数据订阅：此问句是否可以订阅
     *
     * @param request
     * @return
     */
    @PostMapping("canDataSubscription")
    public ApiResponse canDataSubscription(@RequestBody @Validated DataSubscriptionRequest request) {
        if (!aiAssistantService.canDataSubscription(request)) {
            return ApiResponse.buildError(localeService.getLanguageValue(request.getLocale(), "该数据已经订阅了"));
        }
        return ApiResponse.buildOK().setData(true);
    }

    /**
     * 敏捷数据：查询数据收藏
     * 后续使用接口：queryDataCollectionGroup
     * @param queryDTO
     * @return List<DataCollectionModel>·
     * @author yanfeng
     */
    @Deprecated
    @GetMapping("queryDataCollectConfig")
    public ApiResponse queryDataCollectConfig(DataCollectConfigQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryDataCollectConfig(queryDTO));
    }

    /**
     * 敏捷数据：新增数据收藏
     *
     * @param request
     * @return String
     * @author yanfeng
     */
    @PostMapping("addDataCollectConfig")
    public ApiResponse addDataCollectConfig(@RequestBody @Validated DataCollectionAddRequest request) {
        return aiAssistantService.addDataCollectConfig(request);
    }

    /**
     * 敏捷数据：删除数据收藏
     *
     * @param request
     * @return ApiResponse
     * @author yanfeng
     */
    @PostMapping("removeDataCollectConfig")
    public ApiResponse removeDataCollectConfig(@RequestBody @Validated DataCollectionRemoveRequest request) {
        return aiAssistantService.removeDataCollectConfig(request);
    }

    /**
     * 敏捷数据：查询结果(娜娜页面:数据看板)
     *
     * @param request
     * @return ApiResponse
     * @author yanfeng
     */
    @PostMapping("processMessage")
    public ApiResponse processMessage(@RequestBody @Validated ProcessMessageRequest request) {
        return aiAssistantService.processMessage(request);
    }

    /**
     * 敏捷数据：查询已读公告列表
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("queryReadBulletinList")
    public ApiResponse queryReadBulletinList(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryReadBulletinList(apiRequest));
    }

    /**
     * 敏捷数据：查询未读公告列表
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("queryUnreadBulletinList")
    public ApiResponse queryUnreadBulletinList(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryUnreadBulletinList(apiRequest));
    }

    /**
     * 敏捷数据：保存已读公告
     *
     * @param queryDTO
     * @return
     */
    @PostMapping("saveReadBulletin")
    public ApiResponse saveReadBulletin(@RequestBody @Validated BulletinRequest queryDTO) {
        return ApiResponse.buildOK().setData(aiAssistantService.saveReadBulletin(queryDTO));
    }

    /**
     * 敏捷数据：获取流量控制弹窗预警阈值/多场景/多目标/多应用/多sheet页/多指标等
     *
     * @param queryDTO
     * @return
     */
    @PostMapping("queryExceptionInfoByMessageId")
    public ApiResponse getExceptionInfoByMessageId(@RequestBody @Validated EchoInformationModelQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(aiAssistantService.getExceptionInfoByMessageId(queryDTO));
    }

    /**
     * 敏捷数据:查询应用授权信息(娜娜页面：流量查询按钮)
     *
     * @param request
     * @return
     */
    @PostMapping("queryApplicationAuthorizationInformation")
    public ApiResponse queryApplicationAuthorizationInformation(@RequestBody @Validated ApiRequest request) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryApplicationAuthorizationInformation(request));
    }

    /**
     * 敏捷数据:保存用户关闭流量阈值提醒(娜娜页面：不在提醒按钮)
     *
     * @param request
     * @return
     */
    @PostMapping("saveUserCloseTrafficThresholdAlert")
    public ApiResponse saveUserCloseTrafficThresholdAlert(@RequestBody @Validated AgileDataCalculateConfigRequest request) {
        return ApiResponse.buildOK().setData(aiAssistantService.saveUserCloseTrafficThresholdAlert(request));
    }

    /**
     * 敏捷数据:根据当前登陆用户是否是IT人员，来判断是否需要展示异常按钮
     *
     * @param request
     * @return
     */
    @PostMapping("checkIsItUser")
    public ApiResponse checkIsItUser(@RequestBody @Validated ApiRequest request) {
        return ApiResponse.buildOK().setData(aiAssistantService.checkIsItUser(request));
    }

    /**
     * 敏捷数据:获取当前用户指定应用的是否开通了按次计费
     *
     * @param request
     * @return
     * @author yanfeng
     */
    @PostMapping("getTenantApplicationIsBilling")
    public ApiResponse getTenantApplicationIsBilling(@RequestBody @Validated ApiRequest request) {
        return ApiResponse.buildOK().setData(aiAssistantService.getTenantApplicationIsBilling(request));
    }

    /**
     * 敏捷数据：获取异常信息:场景排查和要素解析
     *
     * @param request
     * @return
     */
    @PostMapping("getInfoAndSchemaByMessageId")
    public ApiResponse getInfoAndSchemaByMessageId(@RequestBody @Validated EchoInformationModelQueryDTO request) {
        return ApiResponse.buildOK().setData(aiAssistantService.getInfoAndSchemaByMessageId(request));
    }

    /**
     * 敏捷数据：查询产品公告配置列表
     *
     * @param request
     * @return
     */
    @PostMapping("queryProductBulletinList")
    public ApiResponse queryProductBulletinList(@RequestBody @Validated EchoPageConfigProductBulletinQueryDTO request) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryProductBulletinList(request));
    }

    /**
     * 敏捷数据：查询开场白配置
     *
     * @param request
     * @return
     */
    @PostMapping("queryOpeningRemarksConfig")
    public ApiResponse queryOpeningRemarksConfig(@RequestBody @Validated EchoPageConfigProductBulletinQueryDTO request) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryOpeningRemarksConfig(request));
    }

    /**
     * 敏捷数据：1.查询是否是lite版指定tenantId
     * 2.是否是年报报表租户
     * 控制前端右下角的「订阅」和「收藏」以及数据助理右侧的「看板」和「订阅」入口是否显示
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("queryLiteTenantId")
    public ApiResponse queryLiteTenantId(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryLiteTenantId(apiRequest));
    }

    /**
     * 敏捷数据:发生娜娜消息(lite版)
     *
     * @param queryDTO
     */
    @PostMapping("sendLiteNanaMessage")
    public ApiResponse queryLiteTenantId(@RequestBody AgileDataLiteUploadFileQueryDTO queryDTO) {
        aiAssistantService.sendLiteNanaMessage(queryDTO);
        return ApiResponse.buildOK();
    }

    /**
     * Lite版查询移动端上传限制说明配置
     *
     * @param request
     * @return
     */
    @PostMapping("queryLiteUploadLimitationsConfig")
    public ApiResponse queryLiteUploadLimitationsConfig(@RequestBody ApiRequest request) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryLiteUploadLimitationsConfig(request));
    }

    /**
     * 查询敏捷数据问题排查提效数据列表
     *
     * @param request
     * @return
     */
    @PostMapping("getMongoDbMetricInfoList")
    public ApiResponse getMongoDbMetricInfoList(@RequestBody ApiRequest request) {
        return ApiResponse.buildOK().setData(aiAssistantService.getMongoDbMetricInfoList(request));
    }

    /**
     * 敏捷数据：查询数据收藏分组
     *
     * @param request
     * @return List<DataCollectionGroupModel>
     * @author yanfeng
     */
    @PostMapping("queryDataCollectionGroup")
    public ApiResponse queryDataCollectionGroup(@RequestBody @Validated DataCollectionGroupQueryDTO request) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryDataCollectionGroup(request));
    }

    /**
     * 敏捷数据：新增/更新数据收藏分组
     *
     * @param request
     * @return Boolean
     * @author yanfeng
     */
    @PostMapping("addOrUpdateDataCollectionGroup")
    public ApiResponse addOrUpdateDataCollectionGroup(@RequestBody @Validated DataCollectionGroupAddOrUpdateDTO request) {
        return ApiResponse.buildOK().setData(aiAssistantService.addOrUpdateDataCollectionGroup(request));
    }

    /**
     * 敏捷数据：删除数据收藏分组
     *
     * @param request
     * @return Boolean
     * @author yanfeng
     */
    @PostMapping("deleteDataCollectionGroup")
    public ApiResponse deleteDataCollectionGroup(@RequestBody @Validated DataCollectionGroupDeleteDTO request) {
        return ApiResponse.buildOK().setData(aiAssistantService.deleteDataCollectionGroup(request));
    }

    /**
     * 查询敏捷数据指令集分组列表
     * 需求：39073
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("queryCommandIntentions")
    public ApiResponse queryCommandIntentions(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryCommandIntentions(apiRequest));
    }

    /**
     * 敏捷数据：查询引导提问模糊匹配配置
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("queryFuzzyMatchingConfig")
    public ApiResponse queryFuzzyMatchingConfig(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(aiAssistantService.queryFuzzyMatchingConfig(apiRequest));
    }


    /**
     * 敏捷数据:获取第三方敏数订阅数据
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("getThirdPartyAgileData")
    public ApiResponse getThirdPartyAgileData(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(aiAssistantService.getThirdPartyAgileData(apiRequest));
    }

}