package com.digiwin.mobile.mobileuibot.aiassistant;

import com.digiwin.mobile.mobileuibot.aiassistant.service.AniaAdapterService;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * Created by changcong 0027012250
 * Date 2024/7/15 13:17
 * Description
 */
@Api(value = "API - AniaAdapterController", description = "ania路由")
@RestController
@RequestMapping("/aniaAdapter")
@RequiredArgsConstructor
@Slf4j
@CrossOrigin(origins = "*")
public class AniaAdapterController {

    @Autowired
    private AniaAdapterService aniaAdapterService;

    @PostMapping(value = "/ania/assistant/getMessagesByIds")
    @AdapterUrl(url = "/ania/assistant/getMessagesByIds")
    @ApiOperation(value = "查询知识助理的消息")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true,
            dataType = "String", paramType = "Header")})
    public ApiResponse getMessagesByIds(@RequestBody Map<String,Object> requestParam, HttpServletRequest httpRequest) {
        checkContextToken(httpRequest);
        return aniaAdapterService.sendPost(httpRequest,requestParam);
    }

    public void checkContextToken(HttpServletRequest httpRequest){
        AppRequestContext.ContextEntity contextEntity = AppRequestContext.getContextEntity();
        String iamUserToken = httpRequest.getHeader("iamUserToken");
        if (StringUtils.isEmpty(iamUserToken)) {
            throw new ServiceException("iamUserToken is null");
        }
        contextEntity.setIamUserToken(iamUserToken);
    }
}
