package com.digiwin.mobile.mobileuibot.aiassistant;

import com.digiwin.mobile.mobileuibot.aiassistant.model.AdapterAudcUserTrack;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@Api(value = "API - AdapterController", description = "audc路由")
@RestController
@RequestMapping("/audc")
@RequiredArgsConstructor
@Slf4j
@CrossOrigin(origins = "*")
public class AudcController {

    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    @PostMapping(value = "/user/trace")
    @ApiOperation(value = "移动端数据埋点")
    @ApiImplicitParams({@ApiImplicitParam(name = "authToken", value = "authToken", required = true, dataType = "String", paramType = "Header")})
    public ApiResponse saveUserTrace(@RequestBody AdapterAudcUserTrack adapterAudcUserTrack, HttpServletRequest httpRequest) {

        String iamUserToken = httpRequest.getHeader("iamUserToken");
        if (StringUtils.isEmpty(iamUserToken)) {
            throw new ServiceException("iamUserToken is null");
        }

        String locale = httpRequest.getHeader("locale");
        if (StringUtils.isEmpty(locale)) {
            throw new ServiceException("locale is null");
        }

        String tenantId = adapterAudcUserTrack.getTenantId();
        boolean saved = digiwinAudcProxyService.saveUserTrack(adapterAudcUserTrack.getDigiwinAudcUserTrackList(), locale, iamUserToken, tenantId);
        ApiResponse response = new ApiResponse();
        if (saved) {
            response.setCode("200");
            response.setMsg("success");
        } else {
            response.setCode("500");
            response.setMsg("failure");
        }
        return response;
    }
}