package com.digiwin.mobile.mobileuibot.aiassistant.model;

import java.util.Objects;

/**
 * <p>功能描述：智能助理技能类型枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AiAssistantSkillTypeEnum
 * @Author: zaregoto
 * @Date: 2023/12/19 14:06
 */
public enum AiAssistantSkillTypeEnum {
    /**
     * 敏捷数据
     */
    AGILE_DATA("1"),

    /**
     * 知识助理（文档助理）
     */
    DOCUMENT_ASSISTANT("2"),

    /**
     * 行政助理
     */
    ADMINISTRATIVE_ASSISTANT("3"),

    ;

    private final String value;

    AiAssistantSkillTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static AiAssistantSkillTypeEnum getEnumByValue(String value) {
        for (AiAssistantSkillTypeEnum testedEnum : AiAssistantSkillTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
