package com.digiwin.mobile.mobileuibot.aiassistant.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.FieldType;
import org.springframework.data.mongodb.core.mapping.MongoId;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 敏捷数据模拟数据配置类
 *
 * @author yanfeng
 * @date 2023/9/22
 */
@Document("mockAssistantData")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AssistantMockDataModel implements Serializable {

    private static final long serialVersionUID = 2328702638076216681L;
    @MongoId(FieldType.OBJECT_ID)
    private String _id;

    /**
     * 分类key
     */
    private String mockCategoryKey;

    /**
     * 分类名称
     */
    private String mockCategoryName;

    /**
     * 问题关键词
     * Map key(固定)： CN,TW
     */
    private Map<String, List<String>> questionKey;

    /**
     * mock数据
     * Map key(固定)： CN,TW
     */
    private Map<String, Object> mockData;

    /**
     * 消息是否推送
     */
    private Boolean switchPush;

    /**
     * 消息推送数据
     */
    private Map<String, List<Object>> pushData;

    /**
     * B娜云信消息是否推送
     */
    private Boolean switchAniaPushMessage;

    /**
     * B娜云信消息数据
     * Map key(固定)： CN,TW
     */
    private Map<String, Object> aniaMessageData;

    private Integer sort;

}