package com.digiwin.mobile.mobileuibot.aiassistant.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 敏捷数据:示例/指令集返回给前端实体类
 *
 * @author yanfeng
 * @date 2024/6/27
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ExampleModel implements Serializable {

    private static final long serialVersionUID = 2178982432287323121L;

    private String greeting;

    private Introduce introduce;

    @Data
    public static class Introduce {
        private String title;

        private Template template;

        private Example questionExample;
    }

    @Data
    public static class Template {
        private String text;
        private List<List<Integer>> stressIdxes = new ArrayList<>();
    }

    @Data
    public static class Example {
        private List<QuestionsExampleModel> data;
    }

}