package com.digiwin.mobile.mobileuibot.aiassistant.model.request;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.EnumStringConstraint;
import lombok.Data;

/**
 * <p>功能描述：智能助理提问样例请求模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AiAssistantQuestionExampleRequest
 * @Author: zaregoto
 * @Date: 2024/2/2 17:57
 */
@Data
public class AiAssistantQuestionExampleRequest extends ApiRequest {
    private static final long serialVersionUID = -3444783861281780034L;

    /**
     * 使用的助理技能类型。
     *
     * @see com.digiwin.mobile.mobileuibot.aiassistant.model.AiAssistantSkillTypeEnum
     */
    @EnumStringConstraint(value = {"1", "2", "3"}, message = "skillType must be valid")
    private String skillType;
}
