package com.digiwin.mobile.mobileuibot.aiassistant.model.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 敏捷数据Mock入参
 *
 * @author yanfeng
 * @since 2024/04/01
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AssistantMockDataRequest implements Serializable {

    private static final long serialVersionUID = 5054447517936378801L;

    @NotBlank(message = "语言类别不能为空")
    private String locale;

    @NotBlank(message = "问句不能为空")
    private String inputSentence;

    @NotBlank(message = "Mock类别不能为空")
    private String mockCategoryKey;

    @NotBlank(message = "Token类别不能为空")
    private String iamUserToken;
}
