package com.digiwin.mobile.mobileuibot.aiassistant.model.request;

import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsDataCollectionModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Map;

/**
 * 敏捷数据:数据收藏新增入参
 *
 * @author yanfeng
 * @date 2024/6/28
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DataCollectionAddRequest extends KnowledgeMapsDataCollectionModel {
    private static final long serialVersionUID = 7785398291024334435L;

    @NotBlank(message = "用户Token不能为空")
    private String iamUserToken;

    /**
     * 快照id
     */
    private String snapshotId;

    /**
     * 语言类别
     */
    private String locale;

    /**
     * 问句
     */
    private String question;

    /**
     * metric指标，dataFlow场景数据流
     */
    private String method;

    /**
     * 指标id列表
     */
    private List<String> metricIdList;

    /**
     * 移动分组的时候需要传groupId,如果是新增收藏时新增的分组可传空串
     */
    private String groupId;

    /**
     * 移动分组的时候需要传groupValue
     */
    private String groupValue;

    /**
     * 类型 user是用户，tenant是租户
     */
    private String groupType;

    /**
     * 是否新增收藏
     */
    private Boolean ifAdd = false;

    /**
     * 场景code
     */
    private String sceneCode;

    /**
     * 数据集id列表
     */
    private List<String> datasetIdList;

    /**
     * 解决步骤(透传)
     */
    private Map<String, Object> solutionStep;

    /**
     * 数据集删除需要传questionId(主键)
     */
    private String questionId;

    /**
     * 显示方式
     */
    private String showType;

}