package com.digiwin.mobile.mobileuibot.aiassistant.model.request;

import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsDataSubscriptionModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 敏捷数据-数据订阅入参
 *
 * @author yanfeng
 * @since 2024/04/01
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DataSubscriptionRequest implements Serializable {

    private static final long serialVersionUID = -6030131677490295863L;

    @NotBlank(message = "用户Token不能为空")
    private String iamUserToken;

    /**
     * 租户Id
     */
    @NotBlank(message = "租户Id不能为空")
    private String tenantId;

    /**
     * 用户Id
     */
    @NotBlank(message = "用户Id不能为空")
    private String userId;

    private String userName;

    /**
     * 语言类别
     */
    private String locale;

    /**
     * 问句
     */
    private String question;

    /**
     * 快照id
     */
    private String snapshotId = "";

    /**
     * 场景code
     */
    private String sceneCode;

    /**
     * metric指标，dataFlow场景数据流
     */
    private String method;

    /**
     * 指标id列表
     */
    private List<String> metricIdList = new ArrayList<>();

    /**
     * 助理code(仅查询订阅列表使用)
     */
    private String asaCode = "";

    /**
     * 数据集id列表
     */
    private List<String> datasetIdList;

    /**
     * 显示方式
     */
    private String showType;

    /**
     * 新增/修改/删除使用此对象
     */
    private KnowledgeMapsDataSubscriptionModel dataSubscriptionModel;
}