package com.digiwin.mobile.mobileuibot.aiassistant.service;

import com.digiwin.mobile.mobileuibot.aiassistant.model.ExampleModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.QuestionsExampleModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.*;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.file.dto.AgileDataLiteUploadFileQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.ade.model.AdeDataCollectionGroupListResult;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtTenantApplicationBilling;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtThirdPartyAgileData;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AgileDataCalculateConfigRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.ProcessMessageRequest;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.*;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacApplicationAuthorizationInformation;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsDataCollectionModel;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsDataSubscriptionModel;

import java.util.List;
import java.util.Map;

/**
 * ai智能助手service
 *
 * @author xujinc
 */
public interface AiAssistantService {

    /**
     * 获取消息内容和状态
     *
     * @return
     */
    Map<String, Object> getMessageInfo(MessageInfoRequest messageInfoRequest);

    /**
     * 娜娜消息控件提交
     *
     * @return
     */
    void submitNewRecordOverview(NewRecordOverviewSubmitRequest newRecordOverviewSubmitRequest);

    /**
     * 重新派发任务卡
     *
     * @return
     */
    String taskDistribute(TaskDistributeRequest taskDistributeRequest);

    /**
     * 敏捷数据-Mock数据
     *
     * @param assistantMockDataRequest
     * @return
     */
    List<String> getAssistantMockData(AssistantMockDataRequest assistantMockDataRequest);

    /**
     * 首次获取敏捷数据（数据助理）的提问范例
     *
     * @param locale
     * @return
     */
    String getAgileDataQuestionsExampleFirst(String locale);

    /**
     * 获取敏捷数据（数据助理）的提问范例
     *
     * @param locale
     * @return
     */
    String getAgileDataQuestionsExample(String locale);

    /**
     * 获取文档助理的提问范例
     *
     * @param locale
     * @return
     */
    String getDocumentAssistantQuestionsExample(String locale);

    /**
     * 获取行政助理的提问范例
     *
     * @param locale
     * @return
     */
    String getAdministrativeQuestionsExample(String locale);

    /**
     * 敏捷数据：数据订阅列表
     *
     * @param request
     * @return
     */
    List<KnowledgeMapsDataSubscriptionModel> getDataSubscriptionList(DataSubscriptionRequest request);

    /**
     * 敏捷数据：数据订阅新增/更新
     *
     * @param request
     * @return
     */
    Boolean addOrUpdateDataSubscription(DataSubscriptionRequest request);

    /**
     * 敏捷数据：数据订阅删除
     *
     * @param request
     * @return
     */
    Boolean removeDataSubscription(DataSubscriptionRequest request);

    /**
     * 敏捷数据：数据订阅详情
     *
     * @param iamUserToken
     * @param ruleId
     * @return
     */
    KnowledgeMapsDataSubscriptionModel getDataSubscriptionInfo(String iamUserToken, String ruleId);

    /**
     * 敏捷数据：数据订阅：此问句是否可以订阅
     *
     * @param request
     * @return
     */
    Boolean canDataSubscription(DataSubscriptionRequest request);

    /**
     * 查询用户有权限的助理的数量
     *
     * @param apiRequest
     * @return
     */
    int queryAssistantCount(ApiRequest apiRequest);

    /**
     * 敏捷数据：查询数据收藏
     *
     * @param queryDTO
     * @return List<DataCollectionModel>
     * @author yanfeng
     */
    List<KnowledgeMapsDataCollectionModel> queryDataCollectConfig(DataCollectConfigQueryDTO queryDTO);

    /**
     * 敏捷数据：新增数据收藏
     *
     * @param request
     * @return String
     * @author yanfeng
     */
    ApiResponse addDataCollectConfig(DataCollectionAddRequest request);

    /**
     * 敏捷数据：删除数据收藏
     *
     * @param request
     * @return ApiResponse
     * @author yanfeng
     */
    ApiResponse removeDataCollectConfig(DataCollectionRemoveRequest request);

    /**
     * 敏捷数据：查询示例(娜娜页面:试试这样问我)
     *
     * @param iamUserToken
     * @param locale
     * @return List<SceneIntentionModel>
     * @author yanfeng
     */
    ExampleModel getExample(String iamUserToken, String locale);

    /**
     * 敏捷数据：查询指令集(娜娜页面:魔法棒)
     *
     * @param iamUserToken
     * @param locale
     * @return List<SceneIntentionModel>
     * @author yanfeng
     */
    List<QuestionsExampleModel> querySceneIntentions(String iamUserToken, String locale);

    /**
     * 敏捷数据：查询结果(娜娜页面:数据看板)
     *
     * @param request
     * @return ApiResponse
     * @author yanfeng
     */
    ApiResponse processMessage(ProcessMessageRequest request);

    /**
     * 敏捷数据：查询已读公告列表
     *
     * @param apiRequest
     * @return
     */
    List<EchoGmcBulletinResultDTO> queryReadBulletinList(ApiRequest apiRequest);

    /**
     * 敏捷数据：查询未读公告列表
     *
     * @param apiRequest
     * @return
     */
    EchoGmcBulletinUnReadResultDTO queryUnreadBulletinList(ApiRequest apiRequest);

    /**
     * 敏捷数据：保存已读公告
     *
     * @param request
     * @return
     */
    Boolean saveReadBulletin(BulletinRequest request);

    /**
     * 敏捷数据：获取流量控制弹窗预警阈值/多场景/多目标/多应用/多sheet页/多指标等
     *
     * @param queryDTO
     * @return
     */
    EchoInformationResultDTO getExceptionInfoByMessageId(EchoInformationModelQueryDTO queryDTO);

    /**
     * 敏捷数据:查询应用授权信息(娜娜页面：流量查询按钮)
     *
     * @param request
     * @return
     */
    DigiwinCacApplicationAuthorizationInformation queryApplicationAuthorizationInformation(ApiRequest request);

    /**
     * 敏捷数据:保存用户关闭流量阈值提醒(娜娜页面：不在提醒按钮)
     *
     * @param request
     * @return
     */
    Boolean saveUserCloseTrafficThresholdAlert(AgileDataCalculateConfigRequest request);

    /**
     * 敏捷数据:根据当前登陆用户是否是IT人员，来判断是否需要展示异常按钮
     *
     * @param apiRequest
     * @return
     */
    Boolean checkIsItUser(ApiRequest apiRequest);

    /**
     * 敏捷数据:获取当前用户指定应用的是否开通了按次计费
     *
     * @param request
     * @return
     * @author yanfeng
     */
    DigiwinAdtTenantApplicationBilling getTenantApplicationIsBilling(ApiRequest request);

    /**
     * 敏捷数据：获取异常信息:场景排查和要素解析
     *
     * @param queryDTO
     * @return
     */
    Map<String, Object> getInfoAndSchemaByMessageId(EchoInformationModelQueryDTO queryDTO);

    /**
     * 敏捷数据：查询产品公告配置列表
     *
     * @param queryDTO
     * @return
     */
    List<EchoPageConfigProductBulletinResultDTO> queryProductBulletinList(EchoPageConfigProductBulletinQueryDTO queryDTO);

    /**
     * 敏捷数据：查询开场白配置
     *
     * @param queryDTO
     * @return
     */
    EchoOpeningRemarksConfigResultDTO queryOpeningRemarksConfig(EchoPageConfigProductBulletinQueryDTO queryDTO);

    /**
     * 敏捷数据：1.查询是否是lite版指定tenantId
     * 2.是否是年报报表租户
     * 控制前端右下角的「订阅」和「收藏」以及数据助理右侧的「看板」和「订阅」入口是否显示
     *
     * @param apiRequest
     * @return
     */
    Map<String, Boolean> queryLiteTenantId(ApiRequest apiRequest);

    /**
     * 敏捷数据:发生娜娜消息(lite版)
     *
     * @param queryDTO
     */
    void sendLiteNanaMessage(AgileDataLiteUploadFileQueryDTO queryDTO);

    /**
     * Lite版查询移动端上传限制说明配置
     *
     * @param apiRequest
     * @return
     */
    EchoLiteUploadLimitationsConfigDataResultDTO queryLiteUploadLimitationsConfig(ApiRequest apiRequest);

    /**
     * 查询敏捷数据问题排查提效数据列表
     *
     * @param apiRequest
     * @return
     */
    List<EchoMetricCheckMongoDataResultDTO> getMongoDbMetricInfoList(ApiRequest apiRequest);

    /**
     * 敏捷数据：查询数据收藏分组
     *
     * @param request
     * @return List<DataCollectionGroupModel>
     * @author yanfeng
     */
    AdeDataCollectionGroupListResult queryDataCollectionGroup(DataCollectionGroupQueryDTO request);

    /**
     * 敏捷数据：新增/更新数据收藏分组
     *
     * @param request
     * @return Boolean
     * @author yanfeng
     */
    Boolean addOrUpdateDataCollectionGroup(DataCollectionGroupAddOrUpdateDTO request);

    /**
     * 敏捷数据：删除数据收藏分组
     *
     * @param request
     * @return Boolean
     * @author yanfeng
     */
    Boolean deleteDataCollectionGroup(DataCollectionGroupDeleteDTO request);

    /**
     * 需求：39073
     * 查询敏捷数据新指标指令集列表
     *
     * @param apiRequest
     * @return
     */
    List<EchoInstructionGroupResultDTO> queryCommandIntentions(ApiRequest apiRequest);

    /**
     * 敏捷数据：查询引导提问模糊匹配配置
     *
     * @param apiRequest
     * @return
     */
    EchoFuzzyMatchingConfigDataResultDTO queryFuzzyMatchingConfig(ApiRequest apiRequest);

    /**
     * 敏捷数据:获取第三方敏数订阅数据
     *
     * @param request
     * @return
     */
    DigiwinAdtThirdPartyAgileData getThirdPartyAgileData(ApiRequest request);

}