package com.digiwin.mobile.mobileuibot.aiassistant.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.aiassistant.AdapterUrl;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.AsaDispatchRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.service.AdapterService;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.impl.HttpServiceImpl;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: SunHong
 * @Date: 2024/3/4 17:24
 * @Description:
 */
@Service
public class AdapterServiceImpl implements AdapterService {

    private static final Logger logger = LoggerFactory.getLogger(AdapterServiceImpl.class);

    @Autowired
    private HttpService httpService;

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Autowired
    @Qualifier("asaRestTemplate")
    private RestTemplate asaRestTemplate;

    @Autowired
    private HttpServiceImpl httpServiceImpl;

    @Override
    public ApiResponse sendPost(HttpServletRequest httpServletRequest, Map<String, Object> requestParam) {
        String url = checkAndChangeUrl(httpServletRequest);
        String queryParam = httpServletRequest.getQueryString();
        if (StringUtils.isNotEmpty(queryParam)) {
            url = url + "?" + queryParam;
        }
        ApiResponse response = new ApiResponse();
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = AthenaBasicHttpRequestHead
                .BuilderAsaParam(AppRequestContext.getContextEntity());
        ResponseEntity<Map> responseEntity = httpService.doPost(url, athenaBasicHttpRequestHead,
                JsonUtil.javaObjectToJsonString(requestParam), Map.class);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("asa post message info error");
            throw new ServiceException("asa post message info error");
        }
        Map<String, Object> responseBody = responseEntity.getBody();
        if (responseBody != null) {
            response.setCode(String.valueOf(responseBody.get("code")));
            response.setMsg(String.valueOf(responseBody.get("msg")));
            response.setTraceId(String.valueOf(responseBody.get("traceId")));
            if (Objects.equals(0, responseBody.get("code"))) {
                response.setData(responseBody.get("data"));
            }
        }
        return response;
    }

    @Override
    public ApiResponse sendPost(HttpServletRequest httpServletRequest, Object requestParam) {
        String url = checkAndChangeUrl(httpServletRequest);
        ApiResponse response = new ApiResponse();
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = AthenaBasicHttpRequestHead
                .BuilderAsaParam(AppRequestContext.getContextEntity());
        ResponseEntity<Map> responseEntity = httpService.doPost(url, athenaBasicHttpRequestHead,
                JsonUtil.javaObjectToJsonString(requestParam), Map.class);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("asa post message info error");
            throw new ServiceException("asa post message info error");
        }
        Map<String, Object> responseBody = responseEntity.getBody();
        if (responseBody != null) {
            response.setCode(String.valueOf(responseBody.get("code")));
            response.setMsg(String.valueOf(responseBody.get("msg")));
            response.setTraceId(String.valueOf(responseBody.get("traceId")));
            if (Objects.equals(0, responseBody.get("code"))) {
                response.setData(responseBody.get("data"));
            }
        }
        return response;
    }

    @Override
    public ApiResponse sendGet(HttpServletRequest httpServletRequest, MultiValueMap<String, Object> formDataMap) {
        long startTime1 = System.currentTimeMillis();
        ApiResponse response = new ApiResponse();
        String url = checkAndChangeUrl(httpServletRequest);
        String queryParam = httpServletRequest.getQueryString();
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead =
                AthenaBasicHttpRequestHead.BuilderAsaParam(AppRequestContext.getContextEntity());

        HttpHeaders httpHeader = new HttpHeaders(processHeaders(url, athenaBasicHttpRequestHead, httpServletRequest));
        boolean b = null != httpServletRequest.getContentType()
                && httpServletRequest.getContentType().startsWith(MediaType.MULTIPART_FORM_DATA_VALUE);
        long endTime1 = System.currentTimeMillis();
        logger.debug("ada#sendGet#time1:{}", startTime1 - endTime1);

        long startTime2 = System.currentTimeMillis();
        if (b) {
            httpHeader.setContentType(MediaType.MULTIPART_FORM_DATA);
        } else if (StringUtils.isNotEmpty(queryParam)) {
            url = url + "?" + httpServletRequest.getQueryString();
        }
        // 清理 URL 字符串中的 CRLF 字符
        String sanitizedUrl = url.replace("\r", "").replace("\n", "");
        logger.debug("asa get url is : {}", sanitizedUrl);
        ResponseEntity<Map> responseEntity =
                this.asaRestTemplate.exchange(url, HttpMethod.GET, b ?
                        new HttpEntity<>(formDataMap, httpHeader) : new HttpEntity<>(httpHeader), Map.class);
        long endTime2 = System.currentTimeMillis();
        logger.debug("ada#sendGet#time2:{}", startTime2 - endTime2);

        long startTime3 = System.currentTimeMillis();
        httpServiceImpl.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("asa get message error");
            throw new ServiceException("asa get message error");
        }
        Map<String, Object> responseBody = responseEntity.getBody();
        if (responseBody != null) {
            response.setCode(String.valueOf(responseBody.get("code")));
            response.setMsg(String.valueOf(responseBody.get("msg")));
            response.setTraceId(String.valueOf(responseBody.get("traceId")));
            if (Objects.equals(0, responseBody.get("code"))) {
                response.setData(responseBody.get("data"));
            }
        }
        long endTime3 = System.currentTimeMillis();
        logger.debug("ada#sendGet#time3:{}", startTime3 - endTime3);
        return response;
    }

    public String checkAndChangeUrl(HttpServletRequest requestParam) {
        return sysEnvConfig.getAsaUrl() + "/asa" + requestParam.getRequestURI()
                .replace("asaAdapter/", "");
    }

    @Override
    public ApiResponse sendPost(HttpServletRequest httpServletRequest, MultipartFile file, Map<String, Object> requestParam) {
        ApiResponse response = new ApiResponse();
        String url = checkAndChangeUrl(httpServletRequest);
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead =
                AthenaBasicHttpRequestHead.BuilderAsaParam(AppRequestContext.getContextEntity());
        ResponseEntity<Map> responseEntity = httpService.doPost(url, athenaBasicHttpRequestHead,
                file, requestParam, Map.class);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("asa get message error");
            throw new ServiceException("asa get message error");
        }
        Map<String, Object> responseBody = responseEntity.getBody();
        if (responseBody != null) {
            response.setCode(String.valueOf(responseBody.get("code")));
            response.setMsg(String.valueOf(responseBody.get("msg")));
            response.setTraceId(String.valueOf(responseBody.get("traceId")));
            if (Objects.equals(0, responseBody.get("code"))) {
                response.setData(responseBody.get("data"));
            }
        }
        return response;
    }

    /**
     * 根据栈信息返回适配controller的注解url
     *
     * @return String url
     */
    public String getCurrentMethod() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String methodName = stackTrace[3].getMethodName();
            Class<?> declaringClass = Class.forName(stackTrace[3].getClassName());
            Method[] methods = declaringClass.getDeclaredMethods();
            for (Method method : methods) {
                if (method.getName().equals(methodName) && method.isAnnotationPresent(AdapterUrl.class)) {
                    AdapterUrl annotation = method.getAnnotation(AdapterUrl.class);
                    return sysEnvConfig.getAsaUrl() + "/asa" + annotation.url();
                }
            }
            logger.warn("adapterUrl not present");
        } catch (ClassNotFoundException e) {
            throw new ServiceException("adapterUrl get url error");
        }
        return sysEnvConfig.getAsaUrl();
    }

    public HttpHeaders processHeaders(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, HttpServletRequest request) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("digi-middleware-auth-app", sysEnvConfig.getAppToken());
        httpHeaders.set("digi-middleware-auth-user", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("token", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("client-agent", athenaBasicHttpRequestHead.getClientAgent());
        httpHeaders.set("locale", request.getHeader("locale"));
        // 获取租户ID
        String tenantId = httpServiceImpl.getTenantId(url, athenaBasicHttpRequestHead);
        if (!StringUtils.isEmpty(tenantId)) {
            httpHeaders.set("routerKey", tenantId);
        }
        // 获取代理proxyToken
        String proxyToken = httpServiceImpl.getProxyToken(athenaBasicHttpRequestHead);
        if (!StringUtils.isEmpty(proxyToken)) {
            httpHeaders.set("digi-proxy-token", proxyToken);
        }
        return httpHeaders;
    }

    @Override
    public ApiResponse dispatch(HttpServletRequest request, AsaDispatchRequest asaDispatchRequest) {
        HttpMethod httpMethod = asaDispatchRequest.getHttpMethod();
        Map<String, Object> requestParam = asaDispatchRequest.getRequestParam();

        String dispatchUrl;
        if (StringUtils.isBlank(asaDispatchRequest.getTarget()) || "asa".equals(asaDispatchRequest.getTarget())) {
            dispatchUrl = sysEnvConfig.getAsaUrl() + "/asa" + asaDispatchRequest.getDispatchUrl();
        } else {
            dispatchUrl = AppContext.getApiUrlSetting().getAniaUrl() + "/ania" + asaDispatchRequest.getDispatchUrl();
        }

        //header
        HttpHeaders httpHeader = new HttpHeaders(dispatchHeader(dispatchUrl, request, asaDispatchRequest));
        if (httpMethod == HttpMethod.POST) {
            httpHeader.setContentType(MediaType.APPLICATION_JSON);
        }
        //构建请求
        ResponseEntity<Map> responseEntity = this.asaRestTemplate.exchange(dispatchUrl, httpMethod, new HttpEntity<>(requestParam, httpHeader), Map.class);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("aAdapterServiceImpl.dispatch error dispatchUrl:{}", dispatchUrl);
            throw new ServiceException("asa get message error");
        }
        ApiResponse response = new ApiResponse();
        if (responseEntity.getBody() != null) {
            response.setCode(String.valueOf(responseEntity.getBody().get("code")));
            response.setMsg(String.valueOf(responseEntity.getBody().get("msg")));
            response.setTraceId(String.valueOf(responseEntity.getBody().get("traceId")));
            if (Objects.equals(0, responseEntity.getBody().get("code"))) {
                response.setData(responseEntity.getBody().get("data"));
            }
        }
        return response;
    }


    public HttpHeaders dispatchHeader(String url, HttpServletRequest request, AsaDispatchRequest asaDispatchRequest) {
        AthenaBasicHttpRequestHead athenaHead = AthenaBasicHttpRequestHead.BuilderAsaParam(AppRequestContext.getContextEntity());
        HttpHeaders httpHeaders = processHeaders(url, athenaHead, request);

        List<String> headerKeys = asaDispatchRequest.getHeaderKeys();
        CollUtil.emptyIfNull(headerKeys).forEach(headerKey -> {
            String headerValue = request.getHeader(headerKey);
            if (StrUtil.isNotEmpty(headerValue)) {
                httpHeaders.set(headerKey, headerValue);
            }
        });
        return httpHeaders;
    }

}