package com.digiwin.mobile.mobileuibot.aiassistant.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.aiassistant.constant.AiAssistantConstant;
import com.digiwin.mobile.mobileuibot.aiassistant.model.AssistantMockDataModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.ExampleModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.QuestionsExampleModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.*;
import com.digiwin.mobile.mobileuibot.aiassistant.service.AiAssistantService;
import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.file.dto.AgileDataLiteUploadFileQueryDTO;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.ade.DigiwinAdeProxyService;
import com.digiwin.mobile.mobileuibot.proxy.ade.model.AdeDataCollectionGroupListResult;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtProcessMessage;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtTenantApplicationBilling;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtThirdPartyAgileData;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AgileDataCalculateConfigRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.ProcessMessageRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.service.DigiwinAdtProxyService;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.*;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.DigiwinAgileDataEchoProxyService;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.proxy.ania.service.DigiwinAniaProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacApplicationAuthorizationInformation;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsDataCollectionModel;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsDataSubscriptionModel;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsSceneIntentionModel;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsResponse;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.tdd.service.TddService;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.CompletableFuture;

import static com.digiwin.mobile.mobileuibot.aiassistant.constant.AiAssistantConstant.AGILE_DATA_BOARD_ADD_MORE_THAN_CODE;
import static com.digiwin.mobile.mobileuibot.aiassistant.constant.AiAssistantConstant.AGILE_DATA_BOARD_ADD_REPEAT_CODE;

/**
 * @author xujinc
 */
@Service
public class AiAssistantServiceImpl implements AiAssistantService {

    private static final Logger logger = LoggerFactory.getLogger(AiAssistantServiceImpl.class);

    @Autowired
    private HttpService httpService;

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private DigiwinAimProxyService digiwinAimProxyService;

    @Autowired
    private DigiwinAniaProxyService digiwinAniaProxyService;

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private DigiwinKnowledgeMapsProxyService knowledgeMapsProxyService;

    @Autowired
    private DigiwinAdtProxyService adtProxyService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinAgileDataEchoProxyService echoService;

    @Autowired
    private TddService tddService;

    @Autowired
    private DigiwinAdeProxyService adeProxyService;

    @Override
    public Map<String, Object> getMessageInfo(MessageInfoRequest messageInfoRequest) {
        String url = sysEnvConfig.getAsaUrl() + "/asa/message/athena/info";
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setTenantId(messageInfoRequest.getTenantId());
        athenaBasicHttpRequestHead.setUserToken(messageInfoRequest.getIamUserToken());

        ResponseEntity<Map> responseEntity = execute(athenaBasicHttpRequestHead, JsonUtil.javaObjectToJsonString(messageInfoRequest.getMessageInfoItemList()), url);
        if (Objects.isNull(responseEntity) || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.error("aiAssistant get message info internal error");
            throw new ServiceException("aiAssistant get message info error");
        }
        if (!Objects.equals(responseEntity.getBody().get("code"), 0)) {
            logger.error("aiAssistant get message info failed ,e ={}", responseEntity.getBody().get("msg"));
            throw new ServiceException(String.valueOf(responseEntity.getBody().get("msg")));
        }
        return JsonUtil.objectToJavaObject(responseEntity.getBody().get("data"), new TypeReference<Map<String, Object>>() {
        });
    }

    @Override
    public void submitNewRecordOverview(NewRecordOverviewSubmitRequest newRecordOverviewSubmitRequest) {
        String url = sysEnvConfig.getAsaUrl() + "/asa/newRecordOverview/athena/submit";
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setTenantId(newRecordOverviewSubmitRequest.getTenantId());
        athenaBasicHttpRequestHead.setUserToken(newRecordOverviewSubmitRequest.getIamUserToken());
        ResponseEntity<Map> responseEntity = execute(athenaBasicHttpRequestHead, JsonUtil.javaObjectToJsonString(newRecordOverviewSubmitRequest), url);
        if (Objects.isNull(responseEntity) || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.error("aiAssistant submit newRecordOverview internal error");
            throw new ServiceException("aiAssistant submit newRecordOverview error");
        }
        if (!Objects.equals(responseEntity.getBody().get("code"), 0)) {
            logger.error("aiAssistant submit newRecordOverview failed ,e ={}", responseEntity.getBody().get("msg"));
            throw new ServiceException(String.valueOf(responseEntity.getBody().get("msg")));
        }
    }

    @Override
    public String taskDistribute(TaskDistributeRequest taskDistributeRequest) {
        String url = sysEnvConfig.getAsaUrl() + "/asa/card/task/athena/distribute?source=athena-mobile" +
                "&workItemId=" + taskDistributeRequest.getWorkItemId();
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setTenantId(taskDistributeRequest.getTenantId());
        athenaBasicHttpRequestHead.setUserToken(taskDistributeRequest.getIamUserToken());

        ResponseEntity<Map> responseEntity = execute(athenaBasicHttpRequestHead, Collections.emptyMap(), url);
        if (Objects.isNull(responseEntity) || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.error("aiAssistant card task distribute internal error");
            throw new ServiceException("aiAssistant card task distribute error");
        }
        if (!Objects.equals(responseEntity.getBody().get("code"), 0)) {
            logger.error("aiAssistant card task distribute failed ,e ={}", responseEntity.getBody().get("msg"));
            throw new ServiceException(String.valueOf(responseEntity.getBody().get("msg")));
        }
        return MapUtil.getOrDefault(responseEntity.getBody(), "data", StringUtils.EMPTY);
    }

    @Override
    public int queryAssistantCount(ApiRequest apiRequest) {
        String url = AppContext.getApiUrlSetting().getAniaUrl() + "/ania/athena/assistant/queryAssistantCount" +
                "?clientType=APP";
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setUserToken(apiRequest.getIamUserToken());

        ResponseEntity<Map> responseEntity = execute(athenaBasicHttpRequestHead, Collections.emptyMap(), url);
        if (Objects.isNull(responseEntity) || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.error("aiAssistant get assistant list error");
            throw new ServiceException("aiAssistant get assistant list error");
        }
        if (!Objects.equals(responseEntity.getBody().get("code"), 0)) {
            logger.error("aiAssistant get assistant list failed ,e ={}", responseEntity.getBody().get("msg"));
            throw new ServiceException(String.valueOf(responseEntity.getBody().get("msg")));
        }

        Map returnData = MapUtil.getOrDefault(responseEntity.getBody(), "data", Collections.emptyMap());

        if (!returnData.isEmpty()) {
            return Integer.parseInt(String.valueOf(returnData.get("assistantCount")));
        } else {
            return 0;
        }
    }

    @Override
    public List<String> getAssistantMockData(AssistantMockDataRequest dto) {
        List<String> resultList = new ArrayList<>();
        String locale = dto.getLocale();
        String key = Objects.equals(locale, "zh_CN") ? "CN" : "TW";
        Query query = new Query();
        query.addCriteria(Criteria.where("mockCategoryKey").is(dto.getMockCategoryKey()));
        List<AssistantMockDataModel> assistantMockDataModels = mongoTemplate.find(query, AssistantMockDataModel.class);
        if (assistantMockDataModels.isEmpty()) {
            return resultList;
        }
        assistantMockDataModels.sort(Comparator.comparing(o -> Optional.ofNullable(o.getSort()).orElse(1)));
        assistantMockDataModels.forEach(dataModel -> {
            List<String> ketList = dataModel.getQuestionKey().get(key);
            if (!ketList.isEmpty()) {
                if (ketList.stream().anyMatch(dto.getInputSentence()::contains)) {
                    handleSendIamMessage(dto, dataModel, key);
                    resultList.add(JsonUtil.javaObjectToJsonString(dataModel.getMockData().get(key)));
                }
            }
        });
        return resultList;
    }

    private void handleSendIamMessage(AssistantMockDataRequest dto, AssistantMockDataModel dataModel, String key) {
        if (BooleanUtils.isTrue(dataModel.getSwitchPush())) {
            CompletableFuture.runAsync(() ->
                            digiwinAimProxyService.sendUserMessage(dto.getIamUserToken(), JsonUtil.javaObjectToJsonString(dataModel.getPushData().get(key)))
                    , threadPoolTaskExecutor);
        }
        if (BooleanUtils.isTrue(dataModel.getSwitchAniaPushMessage())) {
            CompletableFuture.runAsync(() ->
                            digiwinAniaProxyService.sendMessage(dto.getIamUserToken(), JsonUtil.javaObjectToJsonString(dataModel.getAniaMessageData().get(key)))
                    , threadPoolTaskExecutor);
        }
    }

    private ResponseEntity<Map> execute(AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, String bodyStr, String url) {
        ResponseEntity<Map> responseEntity;
        try {
            responseEntity =
                    httpService.doPost(url, athenaBasicHttpRequestHead, bodyStr, Map.class);
        } catch (Exception e) {
            logger.error("aiAssistant api execute error :", e);
            throw new ServiceException("aiAssistant api execute error");
        }
        return responseEntity;
    }

    private ResponseEntity<Map> execute(AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, Object> uriVariables, String url) {
        ResponseEntity<Map> responseEntity;
        try {
            responseEntity =
                    httpService.doGet(url, athenaBasicHttpRequestHead, uriVariables, Map.class);
        } catch (Exception e) {
            logger.error("aiAssistant api execute error :", e);
            throw new ServiceException("aiAssistant api execute error");
        }
        return responseEntity;
    }

    @Override
    public String getAgileDataQuestionsExampleFirst(String locale) {
        String dataAssistantQuestionExamplesData = "";
        String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
        // FIXME add on 20240411 微软正式区的指令会少一些，因有些场景还没测通
        if (Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl)) {
            if (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString())) {
                dataAssistantQuestionExamplesData = "{\"greeting\":\"Hi，我是娜娜，很高兴见面！\",\"introduce\":{\"title\":\"试试这样问我\",\"template\":{\"text\":\"我想看「某时间」「某公司/部门/客户/产品」的「金额/趋势/增长状况/排名状况」\",\"stressIdxes\":[[3,39]]},\"questionExample\":{\"data\":[{\"categoryId\":\"S1C3\",\"categoryName\":\"接单\",\"categoryItems\":[{\"itemId\":\"3\",\"text\":\"上月接单排名前五的部门有哪些?\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"营收\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"上个月的营收增长状况如何\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"毛利\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"去年第四季度的毛利金额\",\"stressIdxes\":[]}]}]}}}";
            } else {
                dataAssistantQuestionExamplesData = "{\"greeting\":\"Hi，我是娜娜，很高興見面！\",\"introduce\":{\"title\":\"試試這樣問我\",\"template\":{\"text\":\"我想看「某時間」「某公司/部門/客戶/產品」的「金額/趨勢/增長狀況/排名狀況」\",\"stressIdxes\":[[3,39]]},\"questionExample\":{\"data\":[{\"categoryId\":\"S1C3\",\"categoryName\":\"接單\",\"categoryItems\":[{\"itemId\":\"3\",\"text\":\"上月接單排名前五的部門有哪些?\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"營收\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"上個月的營收增長狀況如何\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"毛利\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"去年第四季度的毛利金額\",\"stressIdxes\":[]}]}]}}}";
            }
        } else {
            if (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString())) {
                dataAssistantQuestionExamplesData = "{\"greeting\":\"Hi，我是娜娜，很高兴见面！\",\"introduce\":{\"title\":\"试试这样问我\",\"template\":{\"text\":\"我想看「某时间」「某公司/部门/客户/产品」的「金额/趋势/增长状况/排名状况」\",\"stressIdxes\":[[3,39]]},\"questionExample\":{\"data\":[{\"categoryId\":\"S1C3\",\"categoryName\":\"接单\",\"categoryItems\":[{\"itemId\":\"3\",\"text\":\"上月接单排名前五的部门有哪些?\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"营收\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"上个月的营收增长状况如何\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"毛利\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"去年第四季度的毛利金额\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"回款\",\"categoryItems\":[{\"itemId\":\"4\",\"text\":\"上月的回款金额如何?\",\"stressIdxes\":[]}]}]}}}";
            } else {
                dataAssistantQuestionExamplesData = "{\"greeting\":\"Hi，我是娜娜，很高興見面！\",\"introduce\":{\"title\":\"試試這樣問我\",\"template\":{\"text\":\"我想看「某時間」「某公司/部門/客戶/產品」的「金額/趨勢/增長狀況/排名狀況」\",\"stressIdxes\":[[3,39]]},\"questionExample\":{\"data\":[{\"categoryId\":\"S1C3\",\"categoryName\":\"接單\",\"categoryItems\":[{\"itemId\":\"3\",\"text\":\"上月接單排名前五的部門有哪些?\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"營收\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"上個月的營收增長狀況如何\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"毛利\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"去年第四季度的毛利金額\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"收款\",\"categoryItems\":[{\"itemId\":\"4\",\"text\":\"上月的收款金額如何?\",\"stressIdxes\":[]}]}]}}}";
            }
        }


        return dataAssistantQuestionExamplesData;
    }

    @Override
    public String getAgileDataQuestionsExample(String locale) {
        String exampleDataString = "";
        String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
        // FIXME add on 20240411 微软正式区的指令会少一些，因有些场景还没测通
        if (Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl)) {
            if (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString())) {
                exampleDataString = "[{\"categoryId\":\"S1C3\",\"categoryName\":\"解构接单问题\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"查下上个月的接单金额?\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"去年接单增长率如何？\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"今年公司接单趋势？\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"上个月接单最好的产品？\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"上月前五大客户接单金额？\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"去年接单最少的三个业务员？\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"今年订单金额最多的三个部门？\",\"stressIdxes\":[]},{\"itemId\":\"8\",\"text\":\"今年已超期的金额有多少\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"解构营收问题\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"今年营收总额\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"今年营收金额趋势？\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"上月营收跟去年对比有什么增长？\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"去年各部门营收状况\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"去年营收业绩垫底的5个产品是哪些？\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"去年营收贡献最差5个客户\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"去年单价波动前五产品\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"解构毛利问题\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"帮我查一下上个月的毛利金额\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"今年公司的毛利增长对比去年的变化\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"去年上半年毛利金额排名前五的客户\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"解构出货问题\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"上月的交货准确率怎么样\",\"stressIdxes\":[]}]}]";
            } else {
                exampleDataString = "[{\"categoryId\":\"S1C3\",\"categoryName\":\"解構接單問題\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"查下上個月的接單金額?\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"去年接單增長率如何？\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"今年公司接單趨勢？\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"上個月接單最好的產品？\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"上月前五大客戶接單金額？\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"去年接單最少的三個業務員？\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"今年訂單金額最多的三個部門？\",\"stressIdxes\":[]},{\"itemId\":\"8\",\"text\":\"今年已超期的金額有多少\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"解構營收問題\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"今年營收總額\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"今年營收金額趨勢？\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"上月營收跟去年對比有什麼增長？\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"去年各部門營收狀況\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"去年營收業績墊底的5個產品是哪些？\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"去年營收貢獻最差5個客戶\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"去年單價波動前五產品\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"解構毛利問題\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"幫我查一下上個月的毛利金額\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"今年公司的毛利增長對比去年的變化\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"去年上半年毛利金額排名前五的客戶\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"解構出貨問題\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"上月的交貨準確率怎麼樣\",\"stressIdxes\":[]}]}]";
            }
        } else {
            if (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString())) {
                exampleDataString = "[{\"categoryId\":\"S1C3\",\"categoryName\":\"解构接单问题\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"查下上个月的接单金额?\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"去年接单增长率如何？\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"今年公司接单趋势？\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"上个月接单最好的产品？\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"上月前五大客户接单金额？\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"去年接单最少的三个业务员？\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"今年订单金额最多的三个部门？\",\"stressIdxes\":[]},{\"itemId\":\"8\",\"text\":\"今年已超期的金额有多少\",\"stressIdxes\":[]},{\"itemId\":\"9\",\"text\":\"上月接单单价低于标准售价的订单有哪些？\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"解构营收问题\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"今年营收总额\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"今年营收金额趋势？\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"上月营收跟去年对比有什么增长？\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"去年各部门营收状况\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"去年营收业绩垫底的5个产品是哪些？\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"去年营收贡献最差5个客户\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"去年单价波动前五产品\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"解构毛利问题\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"帮我查一下上个月的毛利金额\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"今年公司的毛利增长对比去年的变化\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"今年毛利最好的产品？\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"去年上半年毛利金额排名前五的客户\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"解构回款问题\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"去年的回款总额？\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"今年各个客户回款总金额？\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"上个月各业务员的总结款金额？\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"解构出货问题\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"上月的交货准确率怎么样\",\"stressIdxes\":[]}]}]";
            } else {
                exampleDataString = "[{\"categoryId\":\"S1C3\",\"categoryName\":\"解構接單問題\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"查下上個月的接單金額?\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"去年接單增長率如何？\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"今年公司接單趨勢？\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"上個月接單最好的產品？\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"上月前五大客戶接單金額？\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"去年接單最少的三個業務員？\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"今年訂單金額最多的三個部門？\",\"stressIdxes\":[]},{\"itemId\":\"8\",\"text\":\"今年已超期的金額有多少\",\"stressIdxes\":[]},{\"itemId\":\"9\",\"text\":\"上月接單單價低於標準售價的訂單有哪些？\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"解構營收問題\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"今年營收總額\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"今年營收金額趨勢？\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"上月營收跟去年對比有什麼增長？\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"去年各部門營收狀況\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"去年營收業績墊底的5個產品是哪些？\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"去年營收貢獻最差5個客戶\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"去年單價波動前五產品\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"解構毛利問題\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"幫我查一下上個月的毛利金額\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"今年公司的毛利增長對比去年的變化\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"今年毛利最好的產品？\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"去年上半年毛利金額排名前五的客戶\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"解構收款問題\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"去年的收款總額？\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"今年各個客戶收款總金額？\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"上個月各業務員的總結款金額？\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"解構出貨問題\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"上月的交貨準確率怎麼樣\",\"stressIdxes\":[]}]}]";
            }
        }
        return exampleDataString;
    }

    @Override
    public String getDocumentAssistantQuestionsExample(String locale) {
        return "[]";
    }

    @Override
    public String getAdministrativeQuestionsExample(String locale) {
        String exampleDataString = "";
        if (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString())) {
            exampleDataString = "[{\"categoryId\":\"S1C1\",\"categoryName\":\"收集事项\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"娜娜，请帮我向[张三、李四、王五]收集一下[周报]\",\"stressIdxes\":[[7,16],[21,24]]},{\"itemId\":\"1\",\"text\":\"娜娜，请[张三、李四、王五]将他们的[项目进度]回报给我\",\"stressIdxes\":[[4,13],[18,23]]},{\"itemId\":\"1\",\"text\":\"娜娜，请[张三、李四、王五]他们在[A、B、C]中进行投票\",\"stressIdxes\":[[4,13],[17,23]]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"通知事项\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"娜娜，请帮我通知[张三、李四、王五][明天记得早点到]\",\"stressIdxes\":[[8,26]]},{\"itemId\":\"2\",\"text\":\"娜娜，请帮我通知[设计部]发送一个通知，详情见附件\",\"stressIdxes\":[[8,12]]}]}]";
        } else {
            exampleDataString = "[{\"categoryId\":\"S1C1\",\"categoryName\":\"收集事項\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"娜娜，請幫我向[張三、李四、王五]收集一下[週報]\",\"stressIdxes\":[[7,16],[21,24]]},{\"itemId\":\"1\",\"text\":\"娜娜，請[張三、李四、王五]將他們的[專案進度]回報給我\",\"stressIdxes\":[[4,13],[18,23]]},{\"itemId\":\"1\",\"text\":\"娜娜，請[張三、李四、王五]他們在[A、B、C]中進行投票\",\"stressIdxes\":[[4,13],[17,23]]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"通知事項\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"娜娜，請幫我通知[張三、李四、王五][明天記得早點到]\",\"stressIdxes\":[[8,26]]},{\"itemId\":\"2\",\"text\":\"娜娜，請幫我通知[設計部]發送一個通知，詳情見附檔\",\"stressIdxes\":[[8,12]]}]}]";
        }

        return exampleDataString;
    }

    @Override
    public List<KnowledgeMapsDataSubscriptionModel> getDataSubscriptionList(DataSubscriptionRequest request) {
        List<KnowledgeMapsDataSubscriptionModel> subscriptionList = knowledgeMapsProxyService.queryDataSubscriptionList(request);
        subscriptionList.sort((a, b) -> Boolean.compare(b.getScheduleParam().getUndeletable(), a.getScheduleParam().getUndeletable()));
        return subscriptionList;
    }


    @Override
    public Boolean addOrUpdateDataSubscription(DataSubscriptionRequest request) {
        KnowledgeMapsDataSubscriptionModel dataSubscriptionModel = request.getDataSubscriptionModel();
        KnowledgeMapsDataSubscriptionModel.ScheduleParam scheduleParam = dataSubscriptionModel.getScheduleParam();
        scheduleParam.setUserId(request.getUserId());
        scheduleParam.setUserName(request.getUserName());
        scheduleParam.setShowType(request.getShowType());
        scheduleParam.setSnapshotId(request.getSnapshotId());
        if (CollectionUtils.isEmpty(request.getMetricIdList()) && CollectionUtils.isEmpty(request.getDatasetIdList())) {
            //如果前端拿不到场景code,需要后端去获取替换
            if (StringUtils.isBlank(request.getSceneCode())) {
                Assert.notNull(request.getSnapshotId(), "snapshotId must not null");
                String sceneCode = adtProxyService.getSceneCode(request.getIamUserToken(), request.getSnapshotId());
                if (StringUtils.isBlank(sceneCode)) {
                    //场景code为空直接返回false，返回失败
                    return false;
                }
                scheduleParam.setSceneCode(sceneCode);
            } else {
                scheduleParam.setSceneCode(request.getSceneCode());
            }
        } else {
            if (ObjectUtil.isEmpty(scheduleParam.getSolutionStep())) {
                AgileDataApiRequest agileDataApiRequest = AgileDataApiRequest.builder()
                        .iamUserToken(request.getIamUserToken())
                        .tenantId(request.getTenantId())
                        .locale(request.getLocale())
                        .dataId(request.getSnapshotId())
                        .build();
                Map<String, Object> solutionStepBySnapshotMap = adtProxyService.getSolutionStepBySnapshotId(agileDataApiRequest);
                if (ObjectUtil.isEmpty(solutionStepBySnapshotMap)) {
                    return false;
                }
                scheduleParam.setSolutionStep(solutionStepBySnapshotMap);
            }
            if (!CollectionUtils.isEmpty(request.getDatasetIdList())) {
                scheduleParam.setDatasetIdList(request.getDatasetIdList());
            }
            if (!CollectionUtils.isEmpty(request.getMetricIdList())) {
                scheduleParam.setMetricIdList(request.getMetricIdList());
            }
        }
        return knowledgeMapsProxyService.addDataSubscriptionConfig(request);
    }

    @Override
    public Boolean removeDataSubscription(DataSubscriptionRequest request) {
        Assert.notNull(request.getQuestion(), "question must not null");
        if (CollectionUtils.isEmpty(request.getMetricIdList()) && CollectionUtils.isEmpty(request.getDatasetIdList())) {
            //如果前端拿不到场景code,需要后端去获取替换
            getSceneCode(request);
            if (StringUtils.isBlank(request.getSceneCode())) {
                //场景code为空直接返回false，返回失败
                return false;
            }
        }
        return knowledgeMapsProxyService.removeDataSubscriptionConfig(request);
    }

    @Override
    public KnowledgeMapsDataSubscriptionModel getDataSubscriptionInfo(String iamUserToken, String ruleId) {
        return knowledgeMapsProxyService.singleDataSubscriptionConfig(iamUserToken, ruleId);
    }

    @Override
    public Boolean canDataSubscription(DataSubscriptionRequest request) {
        Assert.notNull(request.getLocale(), "locale must not null");
        Assert.notNull(request.getQuestion(), "question must not null");
        getSceneCode(request);
        List<KnowledgeMapsDataSubscriptionModel> dataSubscriptionModels = knowledgeMapsProxyService.queryDataSubscriptionList(request);
        return CollectionUtils.isEmpty(dataSubscriptionModels);
    }

    @Override
    public List<KnowledgeMapsDataCollectionModel> queryDataCollectConfig(DataCollectConfigQueryDTO queryDTO) {
        return knowledgeMapsProxyService.queryDataCollectConfig(queryDTO);
    }

    @Override
    public ApiResponse addDataCollectConfig(DataCollectionAddRequest request) {
        String sceneCode = request.getSceneCode();
        if (CollectionUtils.isEmpty(request.getMetricIdList()) && CollectionUtils.isEmpty(request.getDatasetIdList())) {
            //只有是老场景且是新增操作的时候才去获取场景code
            if (request.getIfAdd()) {
                //快照id换取场景code
                sceneCode = adtProxyService.getSceneCode(request.getIamUserToken(), request.getSnapshotId());
                if (StringUtils.isBlank(sceneCode)) {
                    return ApiResponse.buildError(localeService.getLanguageValue(request.getLocale(), "添加失败,无对应场景"));
                }
            }
        }
        List<KnowledgeMapsDataCollectionModel.DataCollectQuestion> dataCollectQuestions = new ArrayList<>(1);
        KnowledgeMapsDataCollectionModel.DataCollectQuestion dataCollectQuestion = new KnowledgeMapsDataCollectionModel.DataCollectQuestion();
        dataCollectQuestion.setQuestion(request.getQuestion());
        dataCollectQuestion.setSceneCode(sceneCode);
        dataCollectQuestion.setMetricIdList(request.getMetricIdList());
        dataCollectQuestion.setGroupType(request.getGroupType());
        dataCollectQuestion.setGroupValue(request.getGroupValue());
        dataCollectQuestion.setGroupId(request.getGroupId());
        dataCollectQuestion.setDatasetIdList(request.getDatasetIdList());
        dataCollectQuestion.setQuestionId(request.getQuestionId());
        dataCollectQuestion.setShowType(request.getShowType());
        dataCollectQuestion.setSnapshotId(request.getSnapshotId());

        Map<String, Object> solutionStep = request.getSolutionStep();
        if (ObjectUtil.isEmpty(solutionStep)) {
            AgileDataApiRequest agileDataApiRequest = AgileDataApiRequest.builder()
                    .iamUserToken(request.getIamUserToken())
                    .tenantId(request.getTenantId())
                    .locale(request.getLocale())
                    .dataId(request.getSnapshotId())
                    .build();
            Map<String, Object> solutionStepBySnapshotMap = adtProxyService.getSolutionStepBySnapshotId(agileDataApiRequest);
            dataCollectQuestion.setSolutionStep(solutionStepBySnapshotMap);
        } else {
            dataCollectQuestion.setSolutionStep(solutionStep);
        }

        dataCollectQuestions.add(dataCollectQuestion);
        request.setDataCollectQuestions(dataCollectQuestions);
        request.setSolutionStep(null);
        request.setDatasetIdList(null);
        request.setQuestionId(null);
        KnowledgeMapsResponse knowledgeMapsResponse = knowledgeMapsProxyService.addDataCollectConfig(request);
        if (HttpStatus.OK.value() == knowledgeMapsResponse.getStatus()) {
            return ApiResponse.buildOK(localeService.getLanguageValue(request.getLocale(), "收藏成功")).setData(sceneCode);
        } else {
            if (StringUtil.isNotEmpty(knowledgeMapsResponse.getErrorCode())) {
                if (AGILE_DATA_BOARD_ADD_MORE_THAN_CODE.equals(knowledgeMapsResponse.getErrorCode())
                        || AGILE_DATA_BOARD_ADD_REPEAT_CODE.equals(knowledgeMapsResponse.getErrorCode())) {
                    return ApiResponse.buildError(localeService.getLanguageValue(request.getLocale(), knowledgeMapsResponse.getErrorMessage()));
                }
            }
            return ApiResponse.buildError(localeService.getLanguageValue(request.getLocale(), "添加失败,请稍后重试"));
        }
    }

    @Override
    public ApiResponse removeDataCollectConfig(DataCollectionRemoveRequest request) {
        if (BooleanUtils.isFalse(knowledgeMapsProxyService.removeDataCollectConfig(request))) {
            return ApiResponse.buildError(localeService.getLanguageValue(request.getLocale(), "删除失败,请稍后重试"));
        }
        return ApiResponse.buildOK();
    }

    @Override
    public ExampleModel getExample(String iamUserToken, String locale) {
        ExampleModel model = new ExampleModel();
        List<KnowledgeMapsSceneIntentionModel> sceneIntentionModels = knowledgeMapsProxyService.querySceneIntention(iamUserToken, locale);
        if (CollectionUtils.isEmpty(sceneIntentionModels)) {
            return null;
        }
        List<QuestionsExampleModel> list = getQuestionsExampleModels(sceneIntentionModels, false, locale);
        //只取4条返回
        if (list.size() > 4) {
            list = list.subList(0, 4);
        }
        ExampleModel.Example questionExample = new ExampleModel.Example();
        questionExample.setData(list);
        ExampleModel.Template template = new ExampleModel.Template();
        List<List<Integer>> stressIdxes = new ArrayList<>();
        stressIdxes.add(Arrays.asList(3, 39));
        template.setStressIdxes(stressIdxes);
        if (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString())) {
            model.setGreeting("Hi,我是娜娜,很高兴见面!");
            template.setText("我想看「某时间」「某公司/部门/客户/产品」的「金额/趋势/增长状况/排名状况」");
        } else {
            model.setGreeting("Hi,我是娜娜,很高興見面!");
            template.setText("我想看「某時間」「某公司/部門/客戶/産品」的「金額/趨勢/增長狀況/排名狀況」");
        }
        ExampleModel.Introduce introduce = new ExampleModel.Introduce();
        introduce.setTitle(localeService.getLanguageValue(locale, "试试这样问我"));
        introduce.setTemplate(template);
        introduce.setQuestionExample(questionExample);
        model.setIntroduce(introduce);
        return model;
    }

    @Override
    public List<QuestionsExampleModel> querySceneIntentions(String iamUserToken, String locale) {
        List<KnowledgeMapsSceneIntentionModel> sceneIntentionModels = knowledgeMapsProxyService.querySceneIntentions(iamUserToken, locale);
        if (CollectionUtils.isEmpty(sceneIntentionModels)) {
            return new ArrayList<>();
        }
        return getQuestionsExampleModels(sceneIntentionModels, true, locale);
    }

    @Override
    public ApiResponse processMessage(ProcessMessageRequest request) {
        DigiwinAdtProcessMessage response = adtProxyService.processMessage(request);
        if (null == response) {
            return ApiResponse.buildError();
        }
        if (response.getAlarm()) {
            return ApiResponse.buildError(response.getMsg());
        } else {
            return ApiResponse.buildOK().setData(response);
        }
    }

    @Override
    public List<EchoGmcBulletinResultDTO> queryReadBulletinList(ApiRequest apiRequest) {
        return echoService.queryReadBulletinList(apiRequest);
    }

    @Override
    public EchoGmcBulletinUnReadResultDTO queryUnreadBulletinList(ApiRequest apiRequest) {
        return echoService.queryUnreadBulletinList(apiRequest);
    }

    @Override
    public DigiwinCacApplicationAuthorizationInformation queryApplicationAuthorizationInformation(ApiRequest request) {
        DigiwinCacApplicationAuthorizationInformation information = adtProxyService.queryCalculateCacByConfig(request);
        if (information == null) {
            return null;
        }
        information.setQuantityUsage(information.getTotalUsage() - information.getRemainingUsage());
        return information;
    }

    @Override
    public Boolean saveUserCloseTrafficThresholdAlert(AgileDataCalculateConfigRequest request) {
        return adtProxyService.saveUserCloseTrafficThresholdAlert(request);
    }

    @Override
    public Boolean checkIsItUser(ApiRequest apiRequest) {
        return tddService.checkIsItUser(apiRequest);
    }

    @Override
    public DigiwinAdtTenantApplicationBilling getTenantApplicationIsBilling(ApiRequest request) {
        return adtProxyService.getTenantApplicationIsBilling(request);
    }

    @Override
    public Map<String, Object> getInfoAndSchemaByMessageId(EchoInformationModelQueryDTO queryDTO) {
        return echoService.getInfoAndSchemaByMessageId(queryDTO);
    }

    @Override
    public List<EchoPageConfigProductBulletinResultDTO> queryProductBulletinList(EchoPageConfigProductBulletinQueryDTO queryDTO) {
        return echoService.queryProductBulletinList(queryDTO);
    }

    @Override
    public EchoOpeningRemarksConfigResultDTO queryOpeningRemarksConfig(EchoPageConfigProductBulletinQueryDTO queryDTO) {
        // lite演示版本场景,根据租户id,返回固定文案
        if (AiAssistantConstant.AGILE_DATA_HW_LITE_TENANT_ID.equalsIgnoreCase(queryDTO.getTenantId())) {
            EchoOpeningRemarksConfigResultDTO resultDTO = new EchoOpeningRemarksConfigResultDTO();
            if (Locale.TRADITIONAL_CHINESE.toString().equalsIgnoreCase(queryDTO.getLocale())) {
                resultDTO.setTitle("Hi~ 娜娜" + queryDTO.getAssistantName() + "为您服务");
                resultDTO.setContent("你可在底部點擊“+”號，上傳excel文" +
                        "件，我能幫你進行查詢、數據統計等分" +
                        "析");
            } else {
                resultDTO.setTitle("Hi~ 娜娜" + queryDTO.getAssistantName() + "为您服务");
                resultDTO.setContent("你可在底部点击「+」号，上传Excel文" +
                        "件，我能帮你进行查询、数据统计等分" +
                        "析");
            }
            return resultDTO;
        }
        return echoService.queryOpeningRemarksConfig(queryDTO);
    }

    @Override
    public Map<String, Boolean> queryLiteTenantId(ApiRequest apiRequest) {
        String tenantId = apiRequest.getTenantId();
        boolean isHwLiteTenant = AiAssistantConstant.AGILE_DATA_HW_LITE_TENANT_ID.equalsIgnoreCase(tenantId);
        boolean demonstrationTenantId = AiAssistantConstant.AGILE_DATA_DEMONSTRATION_TENANT_ID.equalsIgnoreCase(tenantId);
        boolean isAnnualReportTenant = AiAssistantConstant.AGILE_DATA_ANNUAL_REPORT_TENANT_ID.equalsIgnoreCase(tenantId);
        Map<String, Boolean> map = new HashMap<>();
        //前端是否显示+号功能开关
        map.put("showAddFile", (isHwLiteTenant));
        //前端是否显示数据看板和订阅按钮功能开关
        map.put("showCollectionAndKanban", !(isHwLiteTenant || isAnnualReportTenant));
        //true 用户上传文件功能开放 false 关闭上传文件功能
        map.put("executiveAssistantUploadFileIfOpen", (!demonstrationTenantId));
        return map;
    }


    @Override
    public void sendLiteNanaMessage(AgileDataLiteUploadFileQueryDTO queryDTO) {
        adtProxyService.sendLiteNanaMessage(queryDTO);
    }

    @Override
    public Boolean saveReadBulletin(BulletinRequest request) {
        return echoService.saveReadBulletin(request);
    }

    @Override
    public EchoInformationResultDTO getExceptionInfoByMessageId(EchoInformationModelQueryDTO queryDTO) {
        List<EchoInformationModel> informationModelList = echoService.getExceptionInfoByMessageId(queryDTO);
        if (CollectionUtils.isEmpty(informationModelList)) {
            return null;
        }
        EchoInformationModel informationModel = informationModelList.get(0);
        if (null == informationModel) {
            return null;
        }
        if (null == informationModel.getExtend()) {
            return null;
        }
        EchoInformationResultDTO informationResultDTO = JsonUtil.jsonStringToObject(informationModel.getExtend(), EchoInformationResultDTO.class);
        informationResultDTO.setSelectMultiple(informationModel.getSelectMultiple());
        informationResultDTO.setDataTipMessage(informationModel.getDataTipMessage());
        informationResultDTO.setStepAnalysis(informationModel.getStepAnalysis());
        informationResultDTO.setStepFilterAnalysis(informationModel.getStepFilterAnalysis());
        return informationResultDTO;
    }

    @Override
    public EchoLiteUploadLimitationsConfigDataResultDTO queryLiteUploadLimitationsConfig(ApiRequest apiRequest) {
        return echoService.queryLiteUploadLimitationsConfig(apiRequest);
    }

    @Override
    public List<EchoMetricCheckMongoDataResultDTO> getMongoDbMetricInfoList(ApiRequest apiRequest) {
        return echoService.getMongoDbMetricInfoList(apiRequest);
    }

    @Override
    public AdeDataCollectionGroupListResult queryDataCollectionGroup(DataCollectionGroupQueryDTO request) {
        return adeProxyService.queryDataCollectionGroup(request);
    }

    @Override
    public Boolean addOrUpdateDataCollectionGroup(DataCollectionGroupAddOrUpdateDTO request) {
        return knowledgeMapsProxyService.addOrUpdateDataCollectionGroup(request);
    }

    @Override
    public Boolean deleteDataCollectionGroup(DataCollectionGroupDeleteDTO request) {
        return knowledgeMapsProxyService.deleteDataCollectionGroup(request);
    }

    @Override
    public List<EchoInstructionGroupResultDTO> queryCommandIntentions(ApiRequest apiRequest) {
        return echoService.queryCommandIntentions(apiRequest);
    }

    @Override
    public EchoFuzzyMatchingConfigDataResultDTO queryFuzzyMatchingConfig(ApiRequest apiRequest) {
        return echoService.queryFuzzyMatchingConfig(apiRequest);
    }

    @Override
    public DigiwinAdtThirdPartyAgileData getThirdPartyAgileData(ApiRequest request) {
        return adtProxyService.getThirdPartyAgileData(request);
    }

    private List<QuestionsExampleModel> getQuestionsExampleModels(List<KnowledgeMapsSceneIntentionModel> sceneIntentionModels
            , Boolean isSplice, String locale) {
        List<QuestionsExampleModel> list = new ArrayList<>(sceneIntentionModels.size());
        sceneIntentionModels.forEach(data -> {
            QuestionsExampleModel questionExampleModel = new QuestionsExampleModel();
            if (isSplice) {
                questionExampleModel.setCategoryName(localeService.getLanguageValue(locale, "解构") + data.getTargetName() + localeService.getLanguageValue(locale, "问题"));
            } else {
                questionExampleModel.setCategoryName(data.getTargetName());
            }
            List<QuestionsExampleModel.CategoryItem> categoryItems = new ArrayList<>();
            data.getIntentions().forEach(intention -> {
                QuestionsExampleModel.CategoryItem categoryItem = new QuestionsExampleModel.CategoryItem();
                categoryItem.setText(intention.getIntention());
                categoryItems.add(categoryItem);
            });
            questionExampleModel.setCategoryItems(categoryItems);
            list.add(questionExampleModel);
        });
        return list;
    }

    private void getSceneCode(DataSubscriptionRequest request) {
        //如果前端拿不到场景code,需要后端去获取替换
        if (StringUtils.isBlank(request.getSceneCode())) {
            Assert.notNull(request.getSnapshotId(), "snapshotId must not null");
            String sceneCode = adtProxyService.getSceneCode(request.getIamUserToken(), request.getSnapshotId());
            request.setSceneCode(sceneCode);
        }
    }

}