package com.digiwin.mobile.mobileuibot.aiassistant.service.impl;

import com.digiwin.mobile.mobileuibot.aiassistant.service.AniaAdapterService;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Objects;

/**
 * Created by changcong 0027012250
 * Date 2024/7/15 13:21
 * Description
 */
@Service
@Slf4j
public class AniaAdapterServiceImpl implements AniaAdapterService {

    @Autowired
    private HttpService httpService;

    @Override
    public ApiResponse sendPost(HttpServletRequest httpServletRequest, Map<String, Object> requestParam) {
        String url = checkAndChangeUrl(httpServletRequest);
        ApiResponse response = new ApiResponse();
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = AthenaBasicHttpRequestHead
                .BuilderAsaParam(AppRequestContext.getContextEntity());
        // 清理 URL 字符串中的 CRLF 字符
        String sanitizedUrl = url.replace("\r", "").replace("\n", "");
        log.debug("请求的url:{}", sanitizedUrl);
        requestParam.remove("tenantId");
        requestParam.remove("userId");
        requestParam.remove("appInfo");
        ResponseEntity<Map> responseEntity = httpService.doPost(sanitizedUrl, athenaBasicHttpRequestHead,
                JsonUtil.javaObjectToJsonString(requestParam), Map.class);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            log.debug("ania post message info error");
            throw new ServiceException("ania post message info error");
        }
        Map<String, Object> responseBody = responseEntity.getBody();
        if (responseBody != null) {
            response.setCode("200".equals(String.valueOf(responseBody.get("status"))) ? "0" : "-1");
            response.setMsg(String.valueOf(responseBody.get("errorMessage")));
            response.setTraceId(String.valueOf(responseBody.get("traceId")));
            if (Objects.equals("0", response.getCode())) {
                response.setData(responseBody.get("response"));
            }
        }
        return response;
    }

    public String checkAndChangeUrl(HttpServletRequest requestParam) {
        return AppContext.getApiUrlSetting().getAniaUrl() + requestParam.getRequestURI()
                .replace("aniaAdapter/", "");
    }
}