package com.digiwin.mobile.mobileuibot.announcement;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.view.RedirectView;

import java.util.Locale;

/**
 * <p>功能描述：声明协议页面相关接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AnnouncementController
 * @Author: Zaregoto
 * @Date: 2021/7/16 14:22
 */
@Controller
@RequestMapping("/mobile/v1/announcement")
public class AnnouncementController {
    private static final Logger logger = LoggerFactory.getLogger(AnnouncementController.class);

    @RequestMapping(value = "/service/{locale}", method = {RequestMethod.GET, RequestMethod.POST})
    public RedirectView redirectToServiceContent(@PathVariable("locale") String locale) {
        String targetUrl;
        if (locale.equalsIgnoreCase(Locale.SIMPLIFIED_CHINESE.toString())) {
            targetUrl = "http://imgcn.digiwin.com:18080/athena/20220805-athena-service-mainland-zh_CN.html";
        } else {
            targetUrl = "http://imgcn.digiwin.com:18080/athena/20220805-athena-service-TW-zh_TW.html";
        }
        RedirectView redirectView = new RedirectView();
        redirectView.setUrl(targetUrl);
        return redirectView;
    }

    @RequestMapping(value = "/privacy/{locale}", method = {RequestMethod.GET, RequestMethod.POST})
    public RedirectView redirectToPrivacyContent(@PathVariable("locale") String locale) {
        String targetUrl;
        if (locale.equalsIgnoreCase(Locale.SIMPLIFIED_CHINESE.toString())) {
            targetUrl = "http://imgcn.digiwin.com:18080/athena/20220707-athena-privacy-mainland-zh_CN.html";
        } else {
            targetUrl = "http://imgcn.digiwin.com:18080/athena/20220707-athena-privacy-TW-zh_TW.html";
        }
        RedirectView redirectView = new RedirectView();
        redirectView.setUrl(targetUrl);
        return redirectView;
    }
}
