package com.digiwin.mobile.mobileuibot.api;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：敏捷数据后端接口统一请求数据模型</p>
 *
 * @Author: yanfeng
 * @Date: 2025/6/12
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AgileDataApiRequest implements Serializable {

    @NotNull(message = "token field must exist")
    private String iamUserToken;

    /**
     * 语言别
     */
    @EnumStringConstraint(value = {"zh_CN", "zh_TW", "en_US"}, message = "locale must be valid")
    private String locale;

    @NotNull(message = "tenantId field must exist")
    private String tenantId;

    private String tenantName;

    private String userId;
    /**
     * 当前用户登录用户名
     */
    private String userName;

    /**
     * 应用code
     */
    private String appCode;

    /**
     * 数据Id(比如快照Id等等)
     */
    private String dataId;

    /**
     * 所需转换图表
     */
    private String transId;

    /**
     * 筛选参数
     */
    private Map<String, Object> filterParams;

    /**
     * 业务参数
     */
    private Map<String, Object> businessParameters;

}