package com.digiwin.mobile.mobileuibot.api;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 敏捷数据附件上传接口请求封装
 *
 * @author yanfeng
 * @date 2024/09/02
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AgileDataUploadAttachment implements Serializable {

    private static final long serialVersionUID = 823943253869683390L;

    private MultipartFile file;

    @NotBlank(message = "iamUserToken不能为空")
    private String iamUserToken;

    @NotBlank(message = "userId不能为空")
    private String userId;

    @NotBlank(message = "tenantId不能为空")
    private String tenantId;

    @NotBlank(message = "语言类别不能为空")
    private String locale;

    /**
     * 文件id
     */
    private String fileId;

    /**
     * 是否上传通用报表
     */
    @NotNull(message = "ifCommonFlag不能为空")
    private Boolean ifCommonFlag;

    /**
     * bucket
     */
    @NotBlank(message = "bucket不能为空")
    private String bucket;

    /**
     * 目录名称
     */
    @NotBlank(message = "directoryName不能为空")
    private String directoryName;

}