package com.digiwin.mobile.mobileuibot.api;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.BusinessRawData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotDesignParameter;

import java.io.Serializable;
import java.util.Optional;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiRawData
 * @Author: Zaregoto
 * @Date: 2021/5/21 19:43
 */
public class ApiRawData extends JSONObject implements Serializable {
    private static final long serialVersionUID = -5936702657481177670L;


    /**
     * 设计器v2版 CardList 新增卡片场景入参 -- 当前操作的cardList的mobilePath
     */
    private String currentCardListMobilePath;
    /**
     * 设计器v2版 CardList 新增卡片场景入参 -- 当前操作卡片的dataId
     */
    private String cardItemDataId;

    /**
     * 设计器v2版 CardList 新增卡片场景入参 -- 业务类型 'local-delete'   |   'local-add'  |  'local-save'  |  'other' | ‘filter’
     */
    private String businessType;

    private BusinessRawData businessRawData;

    /**
     * 设计器v2版 运行态的扩展字段结构 -- 透传
     */
    private UiBotDesignParameter designParameter;

    public ApiRawData() {
    }

    public String getCurrentCardListMobilePath() {
        if (null != currentCardListMobilePath) {
            return currentCardListMobilePath;
        }
        return (String) super.get("currentCardListMobilePath");
    }

    public void setCurrentCardListMobilePath(String currentCardListMobilePath) {
        this.currentCardListMobilePath = currentCardListMobilePath;
        super.put("currentCardListMobilePath", currentCardListMobilePath);
    }

    public String getCardItemDataId() {
        if (null != cardItemDataId) {
            return cardItemDataId;
        }
        return (String) super.get("cardItemDataId");
    }

    public void setCardItemDataId(String cardItemDataId) {
        this.cardItemDataId = cardItemDataId;
        super.put("cardItemDataId", cardItemDataId);
    }

    public String getBusinessType() {
        if (null != businessType) {
            return businessType;
        }
        return (String) super.get("businessType");
    }

    public BusinessRawData getBusinessRawData() {
        if (null != businessRawData) {
            return businessRawData;
        }
        return this.businessRawData = Optional
                .ofNullable(JsonUtil.objectToJavaObject(super.get("businessRawData"), BusinessRawData.class))
                .orElse(new BusinessRawData());
    }

    public UiBotDesignParameter getDesignParameter() {
        if (null != designParameter) {
            return designParameter;
        }
        return this.designParameter = Optional
                .ofNullable(JsonUtil.objectToJavaObject(super.get("designParameter"), UiBotDesignParameter.class))
                .orElse(new UiBotDesignParameter());
    }

}