package com.digiwin.mobile.mobileuibot.api;

import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParamJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.PatternTaskInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：本系统后端接口统一请求数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiRequest
 * @Author: Zaregoto
 * @Date: 2021/5/19 14:23
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ApiRequest implements Serializable {
    private static final long serialVersionUID = -6106711555869374772L;

    protected String dataId;

    /**
     * 0老门户1新门户
     */
    private Integer versionDefault;
  @NotNull(message = "iamUserToken field must exist")
    protected String iamUserToken;

    /**
     * 语言别
     */
    @EnumStringConstraint(value = {"zh_CN", "zh_TW", "en_US"}, message = "locale must be valid")
    protected String locale;
    protected String pageId;
    protected String bizId;

    @NotNull(message = "tenantId field must exist")
    protected String tenantId;


    /**
     * 当前用户登录用户名
     */
    protected String userId;
    protected String requestId;
    protected ApiExtraParameter extraParameter;
    protected ApiRawData rawData;
    /**
     * APP相关信息
     */
    protected AppInfo appInfo;
    protected String clientId;
    /**
     * 分页参数--当前页码
     */
    protected Integer pageNum;

    /**
     * 分页参数--页面展示数
     */
    protected Integer pageSize;

    /**
     * 选择的时间
     *
     * @return
     */
    protected String selectDate;

    /**
     * 跳转回上一页的标识，目前仅当为行事历页面的发起任务使用
     *
     * @return
     */
    protected String previousPageId;
    /**
     * 是否为团队行事历的入口
     */
    private Boolean teamEnter;

    private String editId;

    /**
     * 报表跳转使用：跳转的类型  PROJECT_LIST:项目；TASK_LIST:任务；
     */
    private String jumpType;

    /**
     * 需要刷新的页面id
     */
    private String refreshPageId;

    /**
     * 需要刷新的dataId
     */
    private String refreshDataId;

    /**
     * 报表跳转使用：跳转的ID
     */
    private List<String> jumpDataIds;
    /**
     * 报表跳转使用：应用第三方类型
     */
    private String appCode;
    /**
     * 模糊搜索关键字
     */
    private String queryCondition;

    /**
     * 目前用于多层布局已处理数据的回填
     */
    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> params;
    /**
     * V1场景：暂不知
     * V2场景：
     * 1、整批提交--前端保存场景，列表卡片二次修改时。修改页面传递上次修改内容
     * 2、单身新增--前端保存场景，返回刷新卡片列表页面，传递的是新增页面的提交内容
     * ......
     */
    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> submitParam;
    /**
     * V1场景：暂不知
     * V2场景：
     * 1.作用CardList 新增按钮--前端保存场景：存储前端新建Card数据--数据同cardList中cardAllDataList值一致--透传
     * ......
     */
    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> submitParams;
    /**
     * V2场景： -- 新增属性
     * 1、单身新增--前端保存场景，刷新卡片列表页面，传递的是当前页面的表单提交内容
     */
    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> currentSubmitParam;

    //多个卡片的数据
    private List<Map<String, Object>> multiLayoutSubmitParamList;

    /**
     * 行事历请求页面的类型 1：只显示清单页面 2：只显示行事历页面 3：清单和行事历均显示
     */
    private Integer calenderType = 1;
    /**
     * 行事历请求页面 行事历任务列表增加时间范围查询
     */
    private String startDate;
    private String endDate;

    private String linkSchema;
    /**
     * 是否 在途宝应用+ 司机 角色
     * true：是，false：否
     */
    private Boolean isZtbDriver = false;

    /**
     * 移动 任务卡展示 上下文传递处理参数
     */
    private PatternTaskInfo patternTaskInfo;
    /**
     * 面包屑的长度
     */
    private Integer crumbLength;
    /**
     * 主要用于简报速递中消息是否已读
     */
    private Boolean unRead;

    /**
     * 第三方集成 跳转数据驱动任务卡 来源类型
     * nana：来源娜娜
     */
    private String sourceType;
    /**
     * 娜娜消息ID，主要作用是APP中娜娜打开数据驱动任务卡，确定是否提交，提交的是哪个消息
     */
    private String nanaMessageId;

    /**
     * 是否有绿色智机模组权限，true：有权限；false：没有权限
     **/
    private Boolean isHavePreset;

    /**
     * 工作台版本, 值为'v2'走新流程，否则走老流程
     **/
    private String dashboardVersion;

    /**
     * 敏捷数据使用：所需转换图表
     */
    private String transId;

    /**
     * 敏捷数据使用：是否是图形转换
     */
    private Boolean ifChartConvertIf = false;

    /**
     * 敏捷数据使用：筛选参数
     */
    private Map<String, Object> filterParams;

    public PatternTaskInfo getPatternTaskInfo() {
        return patternTaskInfo = Optional.ofNullable(patternTaskInfo).orElse(new PatternTaskInfo());
    }

    public static ApiRequest createEmpty() {
        return new ApiRequest();
    }

    public ApiRawData getRawData() {
        return Optional.ofNullable(rawData).orElse(new ApiRawData());
    }

    public void setRawData(ApiRawData rawData) {
        this.rawData = rawData;
    }
}