package com.digiwin.mobile.mobileuibot.api;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;

/**
 * <p>功能描述：构建组件DSL请求类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiRequestComponent.java
 * @Author: wangjwc
 * @Date: created at 2024/6/6 13:27
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApiRequestComponent extends ApiRequest {
    private static final long serialVersionUID = 2879932409059464455L;

    /**
     * 构建组件DSL请求入参(弃用)，后续统一使用componentData
     */
    @Deprecated
    private ComponentDslDataRequest cardListDslData;

    /**
     * 构建组件DSL请求入参
     */
    private ComponentDslDataRequest componentData;

    /**
     * 统一入口返回对应入参
     *
     * @return
     */
    public ComponentDslDataRequest getComponentData() {
        if (ObjectUtils.isNotEmpty(componentData)) {
            return componentData;
        }
        return cardListDslData;
    }
}