package com.digiwin.mobile.mobileuibot.api;

import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParamJsonDeserializer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionSearchInfoMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import lombok.Getter;

import java.util.List;

/**
 * <p>功能描述: 组件数据查询请求参数</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiRequestComponentDataQuery.java
 * @Author: xujinc
 * @Date: 2024/6/6 13:27
 */
@Data
public class ApiRequestComponentDataQuery extends ApiRequest {
    private static final long serialVersionUID = -8591294272815742045L;
    /**
     * 查询类型：1-分页，2-搜索，3-筛选，4-排序
     * @see QueryType
     */
    private Integer queryType;
    /**
     * 搜索条件
     */
    private Search search;
    /**
     * 筛选条件
     */
    private Filter filter;
    /**
     * 分页条件
     */
    private Paging paging;
    /**
     * 排序条件
     */
    private Sort sort;


    @Getter
    public enum QueryType {
        PAGE(1),
        SEARCH(2),
        FILTER(3),
        SORT(4);

        private final Integer value;

        QueryType(Integer value) {
            this.value = value;
        }
    }

    @Data
    public static class Search {
        // 搜索条件
        private String condition;
        // 搜索字段信息
        private List<PcUiBotActionSearchInfoMapping> searchInfo;
        // 搜索rawdata
        private ApiRawData rawData;
    }

    @Data
    public static class Filter {
        @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
        private List<ActionSubmitParam> submitParams;
        // 筛选rawdata
        private ApiRawData rawData;
    }

    @Data
    public static class Paging {
        // 分页参数
        private PcUiBotPageInfo pageInfo;
        // 分页rawdata
        private ApiRawData rawData;
    }

    @Data
    public static class Sort {
    }
}