package com.digiwin.mobile.mobileuibot.api;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * <p>功能描述：针对ApiRequest请求类的反序列化处理</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiRequestJsonDeserializer
 * @Author: zaregoto
 * @Date: 2024/2/18 18:27
 */
@Slf4j
public class ApiRequestJsonDeserializer extends JsonDeserializer<ApiRequest> {

    @Override
    public ApiRequest deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        log.debug("ApiRequestJsonDeserializer activated!!!");
        ApiRequest apiRequest = null;
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);
        JsonNode generateSerialNoNode = node.get("generateSerialNo");
        if (null == generateSerialNoNode) {
            apiRequest = JsonUtil.objectToJavaObject(node, ApiRequest.class);
        } else {
            apiRequest = JsonUtil.objectToJavaObject(node, ApiRequestAgileDataInAiChat.class);
        }

        return apiRequest;
    }
}
