package com.digiwin.mobile.mobileuibot.api;

import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParamJsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：任务提交请求类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiRequestSubmit
 * @Author: Zaregoto
 * @Date: 2021/5/25 11:52
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApiRequestSubmit extends ApiRequest {
    private static final long serialVersionUID = 7848108059923785293L;

    protected List<ActionSubmitParam> submitParams;

    // 多组数据提交参数，适用于新增删除组时的提交
    protected List<List<ActionSubmitParam>> groupSubmitParamList;

    // 多个卡片的提交，
    protected List<Map<String, Object>> multiLayoutSubmitParamList;

    // 多个卡片的提交 -- 以卡片组件的提交结构传递
    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> multiSubmitParamList;

    /**
     * 位置信息
     */
    private ApiRequestPosition position;
}
