package com.digiwin.mobile.mobileuibot.api;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

/**
 * <p>功能描述：本系统后端接口统一响应数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiResponse
 * @Author: Zaregoto
 * @Date: 2021/4/20 21:43
 */
public class ApiResponse<T> implements Serializable {
    private static final long serialVersionUID = 1875635261853798470L;

    /**
     * 0：正常
     */
    public static final String SUCCESS_CODE = "0";
    /**
     * -1：普通异常
     */
    public static final String ERROR_CODE = "-1";
    /**
     * -2：业务异常，前端会Toast提示msg内容
     */
    public static final String SERVICE_ERROR_CODE = "-2";
    /**
     * 返回码；
     */
    private String code;
    private String msg;
    /**
     * 错误信息，排查问题使用
     */
    private String errorMsg;

    private T data;

    /**
     * 跟踪traceId
     */
    private String traceId;

    public static <T> ApiResponse<T> buildOK() {
        return new ApiResponse<T>(SUCCESS_CODE, "success");
    }

    public static <T> ApiResponse<T> buildOK(T data) {
        ApiResponse<T> success = new ApiResponse<>(SUCCESS_CODE, "success");
        success.setData(data);
        return success;
    }

    public static <T> ApiResponse<T> buildOK(String message) {
        return new ApiResponse<T>(SUCCESS_CODE, message);
    }

    public static <T> ApiResponse<T> buildError() {
        return new ApiResponse<T>(ERROR_CODE, "error");
    }

    public static <T> ApiResponse<T> buildError(String message) {
        return new ApiResponse<T>(ERROR_CODE, message);
    }

    public static <T> ApiResponse<T> buildError(String message, String errorMsg) {
        return new ApiResponse<T>(ERROR_CODE, message, errorMsg);
    }

    public static <T> ApiResponse<T> buildServiceError(String message, String errorMsg) {
        return new ApiResponse<T>(SERVICE_ERROR_CODE, message, errorMsg);
    }

    public static <T> ApiResponse<T> buildMockError(String message) {
        return new ApiResponse<T>("201", message);
    }


    public ApiResponse() {
    }

    public <T> ApiResponse(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public <T> ApiResponse(String code, String msg, String errorMsg) {
        this.code = code;
        this.msg = msg;
        this.errorMsg = errorMsg;
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isOK() {
        return SUCCESS_CODE.equals(this.getCode());
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isError() {
        return !isOK();
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public ApiResponse setData(T data) {
        this.data = data;
        return this;
    }

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }
}
