package com.digiwin.mobile.mobileuibot.api;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * app的版本信息和网络状况模型
 *
 * @author wuyang
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class AppInfo implements Serializable {

    private static final long serialVersionUID = 2978509703865874260L;

    protected String appVersion;
    /**
     * 1.代表WIFI  2.代表2G  3代表3G  4代表4G  5代表5G
     */
    protected String appNetwork;

    /**
     * 屏幕宽度（double字符串）
     */
    protected String screenWidth;

    /**
     * 屏幕高度（double字符串）
     */
    protected String screenHeight;

    /**
     * 前端选择的服务器名称
     */
    protected String serverName;

}
