package com.digiwin.mobile.mobileuibot.api;

import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParamJsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Optional;

/**
 * 构建组件DSL请求入参
 *
 * @author yanfeng
 * @date 2024/5/8
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ComponentDslDataRequest {

    /**
     * PC UI Bot页面相关上下文 --- 渲染当前页面返回的executeContext数据
     */
    private Object executeContext;

    /**
     * 渲染当前页面的请求入参 rawdata数据
     */
    private ApiRawData rawData;

    /**
     * 当前页面的pageId
     */
    private String pageId;

//    /**
//     * 配置规则中写的设计器页面id --- 天岛场景：表单联动单身使用 --- 已废弃
//     */
//    private String designerPageId;

    /**
     * 组件类型
     */
    private String componentType;

    /**
     * 组件运行时UUID --- 即组件的componentId唯一标识
     */
    private String cmptUuid;

//    /**
//     * schema --- 废弃
//     */
//    private String schema;

//    /**
//     * schema全路径 --- 废弃
//     */
//    private String mobilePath;

    /**
     * 前端执行规则异步调用后获得的结果---前端传递此数据作为元数据构建组件
     */
    private Object data;

    /**
     * 修改卡片时，传递的card唯一标识 --- 修改时需要重新赋给构建后的card
     */
    private String dataId;

    /**
     * 数据录入2.0页面的viewCode
     */
    private String viewCode;
    /**
     * 提交参数 --- 点击新增或修改时，以页面提交数据，构建card组件
     */
    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> submitParam;

    public ApiRawData getRawData() {
        return Optional.ofNullable(rawData).orElse(new ApiRawData());
    }
}