package com.digiwin.mobile.mobileuibot.api;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * <p>功能描述：枚举约束注解</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EnumConstraint.java
 * @Author: wangjwc
 * @Date: created at 2025/8/6 15:53
 */
@Target({ElementType.FIELD, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = EnumConstraintValidator.class) // 指定校验器
public @interface EnumConstraint {
    // 错误消息（可默认）
    String message() default "输入值 '{value}' 不合法! 应在 {enumClass} 中，有效选项: {values}";
    
    // 分组
    Class<?>[] groups() default {};
    
    // 负载
    Class<? extends Payload>[] payload() default {};
    
    // 目标枚举类
    Class<? extends Enum<?>> enumClass();
    
    // 枚举值获取方法（默认为name()）
    String valueMethod() default "name";
}