package com.digiwin.mobile.mobileuibot.api;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;

/**
 * <p>功能描述：整型字段的枚举约束校验器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EnumIntegerConstraintValidator
 * @Author: zaregoto
 * @Date: 2024/1/31 19:16
 */
public class EnumIntegerConstraintValidator implements ConstraintValidator<EnumIntegerConstraint, Integer> {

    private int[] enumIntegers;

    @Override
    public void initialize(EnumIntegerConstraint constraintAnnotation) {
        enumIntegers = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(Integer value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        return Arrays.stream(enumIntegers).anyMatch(i -> i == value);
    }
}
