package com.digiwin.mobile.mobileuibot.api;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * <p>功能描述：字符串字段的枚举约束</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EnumStringConstraint
 * @Author: zaregoto
 * @Date: 2024/1/31 19:10
 */
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR,
        ElementType.PARAMETER, ElementType.TYPE_USE})
@Retention(RetentionPolicy.RUNTIME)
@Repeatable(EnumStringConstraint.List.class)
@Documented
@Constraint(validatedBy = EnumStringConstraintValidator.class)//标明由哪个类执行校验逻辑
public @interface EnumStringConstraint {
    String message() default "value not in enum values.";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    /**
     * @return string must in this value array
     */
    String[] value();

    /**
     * Defines several {@link EnumStringConstraint} annotations on the same element.
     *
     * @see EnumStringConstraint
     */
    @Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR,
            ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
        EnumStringConstraint[] value();
    }
}
