package com.digiwin.mobile.mobileuibot.api;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>功能描述：字符串字段的枚举约束校验器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EnumStringConstraintValidator
 * @Author: zaregoto
 * @Date: 2024/1/31 19:16
 */
public class EnumStringConstraintValidator implements ConstraintValidator<EnumStringConstraint, String> {

    private List<String> enumStringList;

    @Override
    public void initialize(EnumStringConstraint constraintAnnotation) {
        enumStringList = Arrays.asList(constraintAnnotation.value());
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        return enumStringList.contains(value);
    }
}
