package com.digiwin.mobile.mobileuibot.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：统一分页响应对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageResult.java
 * @Author: wangjwc
 * @Date: created at 2025/8/8 16:13
 */
@Data
@Accessors(chain = true)
public class PageResult<T> implements Serializable {
    private static final long serialVersionUID = -4408900563385587461L;

    // 当前页数据
    private List<T> data;
    // 总记录数
    private Long total;
    // 当前页数
    private Long pageNum;
    // 每页数量
    private Long pageSize;
    // 总页数
    private Long totalPage;

    public PageResult() {
    }

    private PageResult(Page<T> page) {
        this.data = page.getRecords();
        this.total = page.getTotal();
        this.pageNum = page.getCurrent();
        this.pageSize = page.getSize();
        this.totalPage = page.getPages();
    }

    public static <T> PageResult<T> createPageResult(Page<T> page) {
        return new PageResult<T>(page);
    }
}