package com.digiwin.mobile.mobileuibot.businesslogic;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BusinessLogicHandlerFactory
 * @Author: Zaregoto
 * @Date: 2021/12/29 20:31
 */
@Component("businessLogicHandlerFactory")
public class BusinessLogicHandlerFactory implements InitializingBean, ApplicationContextAware {

    private static final Logger logger = LoggerFactory.getLogger(
        BusinessLogicHandlerFactory.class);

    private static final Map<String, BusinessLogicHandler> BUSINESS_LOGIC_HANDLER_MAP = new HashMap<>();

    private ApplicationContext appContext;

    public BusinessLogicHandler get(String key) {
        return BUSINESS_LOGIC_HANDLER_MAP.get(key);
    }

    @Override public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 BusinessLogicHandler 注册到 BUSINESS_LOGIC_HANDLER_MAP
        this.appContext.getBeansOfType(BusinessLogicHandler.class).values().forEach(
            handler -> BUSINESS_LOGIC_HANDLER_MAP.put(handler.getBusinessType(), handler));
    }

    @Override public void setApplicationContext(ApplicationContext applicationContext)
        throws BeansException {
        this.appContext = applicationContext;
    }
}
