package com.digiwin.mobile.mobileuibot.businesslogic.taskprocessecn;

import com.digiwin.mobile.mobileuibot.businesslogic.BusinessLogicHandler;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.business.bizprocess.BizProcessSubDataItem;
import com.digiwin.mobile.mobileuibot.core.component.business.bizprocess.BizProcessSubDataItemOperateData;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * <p>功能描述：智互联打印任务业务逻辑</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ZhilinkPrintTaskLogicHandler
 * @Author: Zaregoto
 * @Date: 2021/12/29 20:10
 */
@Component("zhilinkPrintTaskLogicHandler")
public class ZhilinkPrintTaskLogicHandler implements BusinessLogicHandler {

    @Override public String getBusinessType() {
        return PageSettingIdPresetEnum.MOBILE_ATHENA_ZHILINK_BARCODEMAN_PRINT_TASK_DETAIL.toString();
    }

    @Override public <R> R handleLogic(MobileComponent mobileComponent, Map<String, Object> bizData,
        Class<R> returnType, Object... args) {
        BizProcessSubDataItem subDataItem = (BizProcessSubDataItem) mobileComponent;

        if (bizData.containsKey("button_type") && bizData.containsKey("button_name")) {
            String buttonType = String.valueOf(bizData.get("button_type"));

            if (!"1".equalsIgnoreCase(buttonType)) {
                BizProcessSubDataItemOperateData operateData = new BizProcessSubDataItemOperateData();
                operateData.addResult("m");

                subDataItem.setOperateData(operateData);
            }
        }

        if (null == returnType) {
            return null;
        } else {
            try {
                return returnType.newInstance();
            } catch (InstantiationException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}
