package com.digiwin.mobile.mobileuibot.common;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>功能描述：错误处理控制器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CommonErrorController.java
 * @Author: wangjwc
 * @Date: created at 2025/8/13 17:33
 */
@Slf4j
@RestController
@RequestMapping
public class CommonErrorController {

    @Autowired
    private LocaleService localeService;

    /**
     * 用户token失效，请重新登录或联系客服专员
     */
    public static final String TOKEN_ERROR = "/error/token-error";

    /**
     * 用户不在白名单中，请联系客服专员
     */
    public static final String WHITE_LIST_ERROR = "/error/white-list-error";

    @RequestMapping(value = TOKEN_ERROR, method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE, RequestMethod.OPTIONS, RequestMethod.HEAD})
    public ApiResponse<Object> tokenError() {
        ApiResponse<Object> response = ApiResponse.buildError(localeService.getLanguageValue("用户token失效，请重新登录或联系客服专员"));
        response.setCode("401");
        return response;
    }

    @RequestMapping(value = WHITE_LIST_ERROR, method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE, RequestMethod.OPTIONS, RequestMethod.HEAD})
    public ApiResponse<Object> whiteListError() {
        return ApiResponse.buildError(localeService.getLanguageValue("用户不在白名单中，请联系客服专员"));
    }
}
