package com.digiwin.mobile.mobileuibot.common.context;

import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.proxy.model.DigiwinApiUrlSetting;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.*;

/**
 * <p>功能描述：全局上下文，保存一些系统初始参数</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppContext
 * @Author: Zaregoto
 * @Date: 2021/4/20 20:59
 */
public final class AppContext {
    private static final Logger logger = LoggerFactory.getLogger(AppContext.class);

    private static DigiwinApiUrlSetting apiUrlSetting = new DigiwinApiUrlSetting();

    /**
     * key=语言别，value=对应语言别下的字典
     */
    private static volatile Map<String, Map<String, String>> DEFAULT_I18N_RESOURCE_MAP =
            new HashMap<>();

    /**
     * 本工程的基础地址。比如：http://172.16.101.163:8081/athena
     */
    private static String baseUrl = "";

    /**
     * 数据是否使用mock
     */
    private static Boolean useMockData = false;

    /**
     * 运行环境类型，默认生产环境。不同环境使用的基础配置参数可能不同。可选值如下：
     * prod, 表示生产环境
     * test, 表示测试环境
     * dev, 表示开发环境
     *
     * @see AppEnvTypeEnum
     */
    private static String envType = "prod";

    /**
     * 环境部署的地区
     *
     * @see AppEnvDeployAreaEnum
     */
    private static String envDeployArea = AppEnvDeployAreaEnum.CN.name();


    public static DigiwinApiUrlSetting getApiUrlSetting() {
        return apiUrlSetting;
    }

    /**
     * @param sysEnvConfig
     */
    public static void setApiUrlSetting(SysEnvConfig sysEnvConfig) {
        AppContext.setBaseUrl(sysEnvConfig.getBaseHost() + ":" + sysEnvConfig.getBasePort() + sysEnvConfig.getBaseUri());
        AppContext.setUseMockData(sysEnvConfig.getUseMockData());
        AppContext.setEnvType(sysEnvConfig.getEnvType());
        AppContext.setEnvDeployArea(sysEnvConfig.getEnvDeployArea());
        // 以下是设置DigiwinApiUrlSetting的属性值
        // 公共配置
        AppContext.apiUrlSetting.setApplicationVersion(sysEnvConfig.getApplicationVersion());
        AppContext.apiUrlSetting.setApplicationBuildTimestamp(sysEnvConfig.getApplicationBuildTimestamp());
        AppContext.apiUrlSetting.setAppToken(sysEnvConfig.getAppToken());
        AppContext.apiUrlSetting.setAppSecret(sysEnvConfig.getAppSecret());
        AppContext.apiUrlSetting.setAesKey(sysEnvConfig.getAesKey());
        AppContext.apiUrlSetting.setLuckycolaUserId(sysEnvConfig.getLuckycolaUserId());
        AppContext.apiUrlSetting.setLuckycolaAppKey(sysEnvConfig.getLuckycolaAppKey());
        AppContext.apiUrlSetting.setBaiduDeveloperAppId(sysEnvConfig.getBaiduDeveloperAppId());
        AppContext.apiUrlSetting.setBaiduDeveloperSecretKey(sysEnvConfig.getBaiduDeveloperSecretKey());
        AppContext.apiUrlSetting.setAkId(sysEnvConfig.getAkId());
        AppContext.apiUrlSetting.setAkSecret(sysEnvConfig.getAkSecret());
        // 对应运行环境配置
        AppContext.apiUrlSetting.setBaseHost(sysEnvConfig.getBaseHost());
        AppContext.apiUrlSetting.setBasePort(sysEnvConfig.getBasePort());
        AppContext.apiUrlSetting.setBaseUri(sysEnvConfig.getBaseUri());
        AppContext.apiUrlSetting.setEnvType(sysEnvConfig.getEnvType());
        AppContext.apiUrlSetting.setEnvDeployArea(sysEnvConfig.getEnvDeployArea());
        AppContext.apiUrlSetting.setEnvDeployEnvironment(sysEnvConfig.getEnvDeployEnvironment());
        AppContext.apiUrlSetting.setUseMockData(sysEnvConfig.getUseMockData());
        AppContext.apiUrlSetting.setUseDigiWhaleLogin(sysEnvConfig.getUseDigiWhaleLogin());
        AppContext.apiUrlSetting.setSwitchTracking(sysEnvConfig.getSwitchTracking());
        AppContext.apiUrlSetting.setSwitchOuterRequestRecord(sysEnvConfig.getSwitchOuterRequestRecord());
        AppContext.apiUrlSetting.setType(sysEnvConfig.getType());
        AppContext.apiUrlSetting.setJpushAppKey(sysEnvConfig.getJpushAppKey());
        AppContext.apiUrlSetting.setJpushMasterSecret(sysEnvConfig.getJpushMasterSecret());
        AppContext.apiUrlSetting.setJpushAndroidIntentComponent(sysEnvConfig.getJpushAndroidIntentComponent());
        AppContext.apiUrlSetting.setImTypeJudgeLocalUrl(sysEnvConfig.getImTypeJudgeLocalUrl());
        AppContext.apiUrlSetting.setImTypeOpenfireLocalUrl(sysEnvConfig.getImTypeOpenfireLocalUrl());
        AppContext.apiUrlSetting.setWebUrl(sysEnvConfig.getWebUrl());
        AppContext.apiUrlSetting.setAllowedOrigin(sysEnvConfig.getAllowedOrigin());
        AppContext.apiUrlSetting.setRouterKey(sysEnvConfig.getRouterKey());
        AppContext.apiUrlSetting.setNanaLineClientId(sysEnvConfig.getNanaLineClientId());
        AppContext.apiUrlSetting.setNanaLineClientSecret(sysEnvConfig.getNanaLineClientSecret());
        AppContext.apiUrlSetting.setAgileDataPrivatization(sysEnvConfig.getAgileDataPrivatization());
        AppContext.apiUrlSetting.setEnableMqtt(sysEnvConfig.getEnableMqtt());
        AppContext.apiUrlSetting.setMqttPassword(sysEnvConfig.getMqttPassword());
        AppContext.apiUrlSetting.setMqttPath(sysEnvConfig.getMqttPath());
        AppContext.apiUrlSetting.setMqttPort(sysEnvConfig.getMqttPort());
        AppContext.apiUrlSetting.setMqttUrl(sysEnvConfig.getMqttUrl());
        AppContext.apiUrlSetting.setMqttUserName(sysEnvConfig.getMqttUserName());
        AppContext.apiUrlSetting.setServerName(sysEnvConfig.getServerName());
        AppContext.apiUrlSetting.setMqttTopicServerNameASA(sysEnvConfig.getMqttTopicServerNameASA());
        AppContext.apiUrlSetting.setAniaMqttServiceName(sysEnvConfig.getAniaMqttServiceName());
        AppContext.apiUrlSetting.setDigiwhaleUrl(sysEnvConfig.getDigiwhaleUrl());
        AppContext.apiUrlSetting.setAiUrl(sysEnvConfig.getAiUrl());
        AppContext.apiUrlSetting.setSdAiUrl(sysEnvConfig.getSdAiUrl());
        AppContext.apiUrlSetting.setKbsUrl(sysEnvConfig.getKbsUrl());
        AppContext.apiUrlSetting.setTbbWebUrl(sysEnvConfig.getTbbWebUrl());
        AppContext.apiUrlSetting.setTbbH5Url(sysEnvConfig.getTbbH5Url());
        AppContext.apiUrlSetting.setTbbApiUrl(sysEnvConfig.getTbbApiUrl());
        AppContext.apiUrlSetting.setCustomTaskTemplateUrl(sysEnvConfig.getCustomTaskTemplateUrl());
        AppContext.apiUrlSetting.setAikafkaUrl(sysEnvConfig.getAikafkaUrl());
        AppContext.apiUrlSetting.setAiGetTopicQtyUrl(sysEnvConfig.getAiGetTopicQtyUrl());
        AppContext.apiUrlSetting.setAamUrl(sysEnvConfig.getAamUrl());
        AppContext.apiUrlSetting.setAdtUrl(sysEnvConfig.getAdtUrl());
        AppContext.apiUrlSetting.setAimUrl(sysEnvConfig.getAimUrl());
        AppContext.apiUrlSetting.setAtdmUrl(sysEnvConfig.getAtdmUrl());
        AppContext.apiUrlSetting.setAtmcUrl(sysEnvConfig.getAtmcUrl());
        AppContext.apiUrlSetting.setAudcUrl(sysEnvConfig.getAudcUrl());
        AppContext.apiUrlSetting.setBiUrl(sysEnvConfig.getBiUrl());
        AppContext.apiUrlSetting.setBpmUrl(sysEnvConfig.getBpmUrl());
        AppContext.apiUrlSetting.setCacUrl(sysEnvConfig.getCacUrl());
        AppContext.apiUrlSetting.setDmcUrl(sysEnvConfig.getDmcUrl());
        AppContext.apiUrlSetting.setEmcUrl(sysEnvConfig.getEmcUrl());
        AppContext.apiUrlSetting.setEocUrl(sysEnvConfig.getEocUrl());
        AppContext.apiUrlSetting.setEspUrl(sysEnvConfig.getEspUrl());
        AppContext.apiUrlSetting.setExperienceUrl(sysEnvConfig.getExperienceUrl());
        AppContext.apiUrlSetting.setIamUrl(sysEnvConfig.getIamUrl());
        AppContext.apiUrlSetting.setImUrl(sysEnvConfig.getImUrl());
        AppContext.apiUrlSetting.setKnowledgeMapsUrl(sysEnvConfig.getKnowledgeMapsUrl());
        AppContext.apiUrlSetting.setThemeMapUrl(sysEnvConfig.getThemeMapUrl());
        AppContext.apiUrlSetting.setLmcUrl(sysEnvConfig.getLmcUrl());
        AppContext.apiUrlSetting.setMdcUrl(sysEnvConfig.getMdcUrl());
        AppContext.apiUrlSetting.setMuiUrl(sysEnvConfig.getMuiUrl());
        AppContext.apiUrlSetting.setNlpBotUrl(sysEnvConfig.getNlpBotUrl());
        AppContext.apiUrlSetting.setOcrApiUrl(sysEnvConfig.getOcrApiUrl());
        AppContext.apiUrlSetting.setSmartDataUrl(sysEnvConfig.getSmartDataUrl());
        AppContext.apiUrlSetting.setTaskEngineUrl(sysEnvConfig.getTaskEngineUrl());
        AppContext.apiUrlSetting.setTddUrl(sysEnvConfig.getTddUrl());
        AppContext.apiUrlSetting.setUibotUrl(sysEnvConfig.getUibotUrl());
        AppContext.apiUrlSetting.setCamUrl(sysEnvConfig.getCamUrl());
        AppContext.apiUrlSetting.setPtmUrl(sysEnvConfig.getPtmUrl());
        AppContext.apiUrlSetting.setSemcUrl(sysEnvConfig.getSemcUrl());
        AppContext.apiUrlSetting.setEchoUrl(sysEnvConfig.getEchoUrl());
        AppContext.apiUrlSetting.setTbbUrl(sysEnvConfig.getTbbUrl());
        AppContext.apiUrlSetting.setAdeUrl(sysEnvConfig.getAdeUrl());
        AppContext.apiUrlSetting.setChatFileUrl(sysEnvConfig.getChatFileUrl());
        AppContext.apiUrlSetting.setAsaUrl(sysEnvConfig.getAsaUrl());
        AppContext.apiUrlSetting.setAniaWebUrl(sysEnvConfig.getAniaWebUrl());
        AppContext.apiUrlSetting.setAniaUrl(sysEnvConfig.getAniaUrl());
        AppContext.apiUrlSetting.setAniaAppsUrl(sysEnvConfig.getAniaAppsUrl());
        AppContext.apiUrlSetting.setKaiwisUrl(sysEnvConfig.getKaiwisUrl());
        AppContext.apiUrlSetting.setAgileDataQueryUrl(sysEnvConfig.getAgileDataQueryUrl());
        AppContext.apiUrlSetting.setAppmetadataUrl(sysEnvConfig.getAppmetadataUrl());
        AppContext.apiUrlSetting.setImportexportUrl(sysEnvConfig.getImportexportUrl());
        AppContext.apiUrlSetting.setGatewayUrl(sysEnvConfig.getGatewayUrl());
        AppContext.apiUrlSetting.setAgileDataFileParsingUrl(sysEnvConfig.getAgileDataFileParsingUrl());
    }

    public static Map<String, Map<String, String>> getDefaultI18nResourceMap() {
        return DEFAULT_I18N_RESOURCE_MAP;
    }

    public static void setDefaultI18nResourceMap(
            Map<String, Map<String, String>> defaultI18nResourceMap) {
        DEFAULT_I18N_RESOURCE_MAP = defaultI18nResourceMap;
    }

    public static String getBaseUrl() {
        return baseUrl;
    }

    public static void setBaseUrl(String baseUrl) {
        AppContext.baseUrl = baseUrl;
    }

    public static Boolean getUseMockData() {
        return useMockData;
    }

    public static void setUseMockData(Boolean useMockData) {
        if (null != useMockData) {
            AppContext.useMockData = useMockData;
        }
    }

    public static String getEnvType() {
        return envType;
    }

    public static void setEnvType(String envType) {
        if (null != envType && !envType.isEmpty()) {
            AppContext.envType = envType;
        }
    }

    public static String getEnvDeployArea() {
        return envDeployArea;
    }

    public static void setEnvDeployArea(String envDeployArea) {
        if (null != envDeployArea && !envDeployArea.isEmpty()) {
            AppContext.envDeployArea = envDeployArea;
        }
    }

    /**
     * 检查环境部署地区 是否  是台湾 prod 环境
     *
     * @return TRUE：是  false：否
     */
    public static Boolean checkEnvDeployAreaTwProd() {
        if (!AppEnvTypeEnum.PRODUCTION.getEnvType().equals(getEnvType())) {
            return Boolean.FALSE;
        }
        return AppEnvDeployAreaEnum.TW.name().equals(getEnvDeployArea());
    }

    public static String getUrl(String urlName) {
        try {
            Field[] fieldList = apiUrlSetting.getClass().getDeclaredFields();
            Optional<Field> fieldOptional = Arrays.stream(fieldList).filter(e -> e.getName().equalsIgnoreCase(urlName)).findFirst();
            if (!fieldOptional.isPresent()) {
                return StringUtils.EMPTY;
            }
            Field field = fieldOptional.get();
            field.setAccessible(true);
            Object val = field.get(apiUrlSetting);
            return Objects.isNull(val) ? StringUtils.EMPTY : String.valueOf(val);
        } catch (Exception e) {
            logger.error("DigiwinApiUrlSetting getUrl error: ", e);
        }
        return StringUtils.EMPTY;
    }
}