package com.digiwin.mobile.mobileuibot.common.context;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Objects;

/**
 * <p>功能描述：本应用运行时收到请求的上下文</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppRequestContext
 * @Author: Zaregoto
 * @Date: 2021/11/29 20:19
 */
public final class AppRequestContext {

    // 请求头 渲染版本号key
    public static final String REQUEST_HEADER_KEY_RENDERVERSION = "renderVersion";

    public static final String REQUEST_CONTEXT_KEY_MODELTYPE = "modelType";
    public static final String REQUEST_CONTEXT_VALUE_SHOW = "show";
    // mock 体验下请求头设置的value值
    public static final String REQUEST_CONTEXT_VALUE_MOCK = "mock";

    // Demo体验模式角色code之key
    public static final String REQUEST_CONTEXT_KEY_EXPERIENCE_MODE_ROLE = "roleId";

    // Demo体验模式采购项目经理角色code
    public static final String REQUEST_CONTEXT_VALUE_EXPERIENCE_MODE_ROLECODE_PROJECT_MANAGER = "PROJECT_MANAGER";

    // Demo体验模式采购主管角色code
    public static final String REQUEST_CONTEXT_VALUE_EXPERIENCE_MODE_ROLECODE_PURCHASING_MANAGER = "PURCHASING_MANAGER";

    /**
     * 存放请求拦截的参数，贯穿整个请求链
     */
    private static final TransmittableThreadLocal<ContextEntity> REQUEST_CONTEXT = new TransmittableThreadLocal<>();

    public static ContextEntity getContextEntity() {
        ContextEntity context = REQUEST_CONTEXT.get();
        if (Objects.isNull(context)) {
            synchronized (AppRequestContext.class) {
                REQUEST_CONTEXT.set(context = new ContextEntity());
            }
        }
        return context;
    }

    public static void remove() {
        REQUEST_CONTEXT.remove();
    }

    /**
     * 根据前端请求头参数，判断前端是否需要mock数据
     *
     * @return
     * @see com.digiwin.mobile.mobileuibot.config.request.RequestContextInterceptor
     */
    public static boolean requestNeedShowMockData() {
        return AppRequestContext.REQUEST_CONTEXT_VALUE_SHOW.equals(getContextEntity().getModelType());
    }

    /**
     * 功能: 存储请求中参数值
     *
     * @author: wjw
     * @date: created at 2023/1/20
     */
    @Data
    @Accessors(chain = true)
    public static class ContextEntity {

        /**
         * 租户ID
         */
        private String tenantId;

        /**
         * 语言别
         */
        private String locale;

        /**
         * 请求模式。可选值如下：
         * show:表示Demo体验模式
         */
        private String modelType;

        /**
         * Demo体验模式下的角色ID
         */
        private String experienceRoleId;

        /**
         * 用户ID
         */
        private String userId;

        /**
         * 前端传递的app使用的渲染引擎版本号。
         * 若该字段没有值，或版本号不为2，则前端app会使用旧渲染引擎与相关配套组件（无BaseComponent版本）
         * 若该字段有值，且版本号为2，则前端app会使用新渲染引擎与相关配套组件（有BaseComponent版本）
         * add by mowj 20230208
         *
         * @see com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData
         */
        private Integer renderVersion;

        /**
         * 是否升级，此字段主要作用于自定义反序列化中，是否按照升级的结构反序列化
         * 默认false
         */
        private Boolean isUpgrade;
        /**
         * 页面ID
         */
        private String pageId;
        /**
         * 请求URI
         * 去除了请求时多个斜杠
         */
        private String requestUri;
        /**
         * 请求的代理proxyToken，
         * 主要作用于line场景下任务卡获取应用数据
         */
        private String proxyToken;
        /**
         * 当前登录人token
         */
        private String iamUserToken;
        /**
         * 是否是团队任务
         * 默认false
         */
        private Boolean isTeamTask;

        /**
         * 是否分享他人
         * 默认false
         */
        private Boolean pinning;

        /**
         * 多数据源名称,和组件里面多数据名称相同，这边是透传处理
         */
        private String dataSourceName;

        /**
         * 数据id
         */
        private String dataId;

        /**
         * @see SsoSourceTypeEnum
         * 第三方来源
         */
        private String sourceType;
    }

}
