package com.digiwin.mobile.mobileuibot.common.http;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

import java.io.IOException;

/**
 * 请求三方接口调用时间记录
 *
 * @author zhangjj
 * @date 2022/3/7 0007 15:14
 */
public class DigiwinHttpReqTimeInterceptor implements ClientHttpRequestInterceptor {

    private Logger logger = LoggerFactory.getLogger(DigiwinHttpReqTimeInterceptor.class);

    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        logger.debug("========================外部HTTP请求拦截-request===========================" +
                        "\nrequestUrl：{}" +
                        "\nrequestTime：{}",
                request.getURI(), DateTimeUtil.getTodayTimeUseDefaultPattern());
        long startTime = System.currentTimeMillis();
        ClientHttpResponse response = execution.execute(request, body);
        long endTime = System.currentTimeMillis();
        logger.debug("========================外部HTTP请求拦截-response==========================" +
                        "\nrequestUrl：{}" +
                        "\nresponseTime：{}" +
                        "\nrunningTime：{}ms",
                request.getURI(), DateTimeUtil.getTodayTimeUseDefaultPattern(), endTime - startTime);
        return response;
    }
}
