package com.digiwin.mobile.mobileuibot.common.http;

import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleBasicHttpRequestHead;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：基础HTTP调用服务，基于Spring的RestTemplate封装基础参数</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: HttpService
 * @Author: Zaregoto
 * @Date: 2021/4/21 2:17
 */
public interface HttpService {

    <T> ResponseEntity<T> doGet(String url, Class<T> clazz);

    <T> ResponseEntity<T> doGet(String url, ParameterizedTypeReference<T> responseType);

    <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, Class<T> clazz);

    <T> ResponseEntity<T> doGet(String url, DigiwhaleBasicHttpRequestHead digiwhaleBasicHttpRequestHead, Map<String, ?> uriVariables, Class<T> clazz);

    <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, ParameterizedTypeReference<T> responseType);

    <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, ParameterizedTypeReference<T> responseType);

    <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, Class<T> clazz);

    <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, String bodyPayload, Class<T> clazz);

    <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, String bodyPayload, ParameterizedTypeReference<T> responseType);

    <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, ParameterizedTypeReference<T> responseType);

    <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, ParameterizedTypeReference<T> responseType);

    <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Class<T> clazz);

    <T> ResponseEntity<T> doPost(String url, ParameterizedTypeReference<T> responseType);

    <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, MultipartFile file,
                                 Map<String, ?> uriVariables, Class<T> clazz);

    <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead,
                                 List<MultipartFile> files, Map<String, ?> requestParam, ParameterizedTypeReference<T> responseType);
}
