package com.digiwin.mobile.mobileuibot.common.http.constant;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvTypeEnum;

import java.time.Duration;

/**
 * <p>功能描述：超时时间枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TimeOutEnum
 * @Author: xujinc
 * @Date: 2023/6/21 16:29
 */
public enum TimeOutEnum {
    /**
     * 开发环境
     */
    DEV_MS(120000L),

    /**
     * 测试环境
     */
    TEST_MS(120000L),

    /**
     * 生产环境
     */
    PROD_MS(120000L),

    /**
     * 默认值
     */
    DEFAULT_MS(120000L);

    private Long millisecond;

    TimeOutEnum(Long millisecond) {
        this.millisecond = millisecond;
    }

    public Long getMillisecond() {
        return millisecond;
    }

    public static Long getMillisByEnvType() {
        String envType = AppContext.getEnvType();
        if (envType.equalsIgnoreCase(AppEnvTypeEnum.PRODUCTION.getEnvType())) {
            return PROD_MS.millisecond;
        } else if (envType.equalsIgnoreCase(AppEnvTypeEnum.TEST.getEnvType())) {
            return TEST_MS.millisecond;
        } else if (envType.equalsIgnoreCase(AppEnvTypeEnum.DEVELOP.getEnvType())) {
            return DEV_MS.millisecond;
        } else {
            return DEFAULT_MS.millisecond;
        }
    }

    public static Long getSecondByEnvType() {
        Long millisByEnvType = getMillisByEnvType();
        return millisByEnvType / 1000;
    }

    public static Duration getDuration() {
        return Duration.ofMillis(getMillisByEnvType());
    }
}