package com.digiwin.mobile.mobileuibot.common.http.model;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>功能描述：鼎捷Athena系统API请求的基础头部数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AthenaBasicHttpRequestHead
 * @Author: Zaregoto
 * @Date: 2021/4/25 14:59
 */
@Data
@Accessors(chain = true)
public class AthenaBasicHttpRequestHead extends BasicHttpRequestHead {
    private static final long serialVersionUID = 5146518154657372801L;

    private String clientAgent = "mobileplatform";
    private String locale;
    private String userToken;
    private String tenantId;
    private String proxyToken;
    private String acceptLanguage;
    private String deviceType = "";
    private String deviceId = "";
    private String sourceFrom = "";
    private String iamDeviceId = "";

    public String getLocale() {
        if (StringUtils.isBlank(this.locale)) {
            this.locale = AppRequestContext.getContextEntity().getLocale();
        }
        // 防止httpHeaders中set-null，导致空指针异常
        if (this.locale == null) {
            this.locale = "";
        }
        return this.locale;
    }

    public String getUserToken() {
        if (StringUtils.isBlank(this.userToken)) {
            this.userToken = AppRequestContext.getContextEntity().getIamUserToken();
        }
        // 防止httpHeaders中set-null，导致空指针异常
        if (this.userToken == null) {
            this.userToken = "";
        }
        return this.userToken;
    }

    public String getTenantId() {
        if (StringUtils.isBlank(this.tenantId)) {
            this.tenantId = AppRequestContext.getContextEntity().getTenantId();
        }
        // 防止httpHeaders中set-null，导致空指针异常
        if (this.tenantId == null) {
            this.tenantId = "";
        }
        return this.tenantId;
    }

    public AthenaBasicHttpRequestHead() {
        this.locale = "";
        this.userToken = "";
    }

    public AthenaBasicHttpRequestHead(String userToken) {
        this();
        this.userToken = userToken;
    }

    @Deprecated
    /**
     * 需要改用传递租户ID的构造方法
     */
    public AthenaBasicHttpRequestHead(String locale, String userToken) {
        this.locale = locale;
        this.userToken = userToken;
    }

    @Deprecated
    /**
     * 需要改用传递租户ID的构造方法
     */
    public AthenaBasicHttpRequestHead(String clientAgent, String locale, String userToken) {
        this.clientAgent = clientAgent;
        this.locale = locale;
        this.userToken = userToken;
    }

    public AthenaBasicHttpRequestHead(String clientAgent, String locale, String userToken, String tenantId) {
        this.clientAgent = clientAgent;
        this.locale = locale;
        this.userToken = userToken;
        this.tenantId = tenantId;
    }

    public AthenaBasicHttpRequestHead(String clientAgent, String locale, String userToken, String tenantId, String proxyToken) {
        this.clientAgent = clientAgent;
        this.locale = locale;
        this.userToken = userToken;
        this.tenantId = tenantId;
        this.proxyToken = proxyToken;
    }

    public static AthenaBasicHttpRequestHead BuilderAsaParam(AppRequestContext.ContextEntity contextEntity) {
        AthenaBasicHttpRequestHead requestHead = new AthenaBasicHttpRequestHead();
        requestHead.setTenantId(String.valueOf(contextEntity.getTenantId()));
        requestHead.setUserToken(String.valueOf(contextEntity.getIamUserToken()));
        return requestHead;
    }

    public static AthenaBasicHttpRequestHead buildByRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String token = request.getHeader("token");
        if (StringUtils.isNotBlank(locale)) {
            return new AthenaBasicHttpRequestHead(locale, token);
        }
        return new AthenaBasicHttpRequestHead(token);

    }
}
