package com.digiwin.mobile.mobileuibot.common.logrecord;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.pipeline.PipelineFactory;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipeline;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * 功能: 此接口说明对添加了@Controller的类织入一个通知(增强功能)
 *
 * @author: wjw
 * @date: created at 2023/2/15
 */
@Slf4j
@RestControllerAdvice
public class MobileUibotResponseBodyAdvice implements ResponseBodyAdvice<ApiResponse> {

    @Autowired
    private PipelineFactory pipelineFactory;

    /**
     * 功能: supports方法是来给定条件判断是否该调用beforeBodyWrite
     *
     * @param returnType
     * @param aClass
     * @return 返回值
     */
    @Override
    public boolean supports(MethodParameter returnType, @NotNull Class<? extends HttpMessageConverter<?>> aClass) {
        return ApiResponse.class.isAssignableFrom(returnType.getParameterType());
    }

    @Override
    public ApiResponse beforeBodyWrite(ApiResponse result, @NotNull MethodParameter methodParameter,
                                       @NotNull MediaType mediaType,
                                       @NotNull Class<? extends HttpMessageConverter<?>> aClass,
                                       @NotNull ServerHttpRequest serverHttpRequest,
                                       @NotNull ServerHttpResponse serverHttpResponse) {
        // 执行 DSL生成管道节点逻辑
        pipelineFactory.getPipeline(DslGeneratePipeline.class).execute(result);
        return result;
    }
}
