package com.digiwin.mobile.mobileuibot.common.logrecord;

import com.digiwin.mobile.mobileuibot.config.request.mock.MockInterceptor;
import com.digiwin.mobile.mobileuibot.config.request.mock.OuterMockData;
import com.digiwin.mobile.mobileuibot.model.db1.OuterRequestRecord;
import com.digiwin.mobile.mobileuibot.mysql.service.OuterRequestRecordService;
import com.digiwin.mobile.mobileuibot.proxy.experience.service.DigiwinExperienceProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

/**
 * 功能: 日志处理器
 *
 * @author: wjw
 * @date: created at 2023/2/16
 */
@Component
public class OuterRequestRecordManage {

    private static final Logger logger = LoggerFactory.getLogger(OuterRequestRecordManage.class);
    /**
     * 缓存日志内容，默认容量 1000
     */
    private static BlockingDeque<OuterRequestRecord> BLOCKING_DEQUE = new LinkedBlockingDeque<>(1000);

    /**
     * 批量插入个数
     */
    private static int BATCHNUM = 100;

    @Autowired
    private OuterRequestRecordService outerRequestRecordService;

    @Autowired
    private DigiwinExperienceProxyService digiwinExperienceProxyService;

    public OuterRequestRecordManage() {
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    this.asyncOuterRequestRecord();
                    this.asyncMockData();
                } catch (Exception e) {
                    logger.error("OuterRequestRecordManage Failed to save log record, error:", e);
                }
            }
        });
        thread.setName("OuterRequestRecordManage");
        thread.start();
    }

    public void add(OuterRequestRecord outerRequestRecord) {
        BLOCKING_DEQUE.offer(outerRequestRecord);
    }

    private void asyncOuterRequestRecord() {
        try {
            Thread.sleep(50);
        } catch (InterruptedException e) {
            logger.error("asyncOuterRequestRecord interruptedException, error:", e);
        } catch (Exception e) {
            logger.error("asyncOuterRequestRecord failed, error:", e);
        }

        final OuterRequestRecord firstRecord = BLOCKING_DEQUE.poll();
        if (null == firstRecord) {
            return;
        }

        // 批量插入
        List<OuterRequestRecord> recordList = new ArrayList<>();
        recordList.add(firstRecord);
        for (int i = 1; i < BATCHNUM; i++) {
            OuterRequestRecord record = BLOCKING_DEQUE.poll();
            if (null == record) {
                break;
            }
            recordList.add(record);
        }

        outerRequestRecordService.batchInsert(recordList);
    }

    private void asyncMockData() {
        try {
            Thread.sleep(50);
        } catch (InterruptedException e) {
            logger.error("asyncMockData interruptedException, error:", e);
        } catch (Exception ignored) {
        }

        final OuterMockData outerMockData = MockInterceptor.BLOCKING_DEQUE.poll();
        if (null == outerMockData) {
            return;
        }
        digiwinExperienceProxyService.reportMockData(outerMockData);
    }
}
