package com.digiwin.mobile.mobileuibot.common.utils;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.proxy.model.DigiwinApiUrlSetting;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：返回给前端的 api配置转换工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiConverUtils.java
 * @Author: wangjwc
 * @Date: created at 2025/7/24 16:30
 */
public class ApiConverUtils {
    // api 前缀
    private static final String API_PREFIX = "/idrive-apis";
    // 服务专案与网关路径映射
    private static final Map<String, String> SERVER_MAP = new HashMap<>();

    // 服务键常量
    private static final String AAM = "aam";
    private static final String ATDM = "atdm";
    private static final String ATMC = "atmc";
    private static final String AUDC = "audc";
    private static final String UIBOT = "uibot";
    private static final String IM = "im";
    private static final String KNOWLEDGEGRAPH = "knowledgegraph";
    private static final String TASKENGINE = "taskengine";
    private static final String TDD = "tdd";
    private static final String PTM = "ptm";
    private static final String APPMETADATA = "idrive-platform-appmetadata";
    private static final String IMPORTEXPORT = "idrive-business-importexport";

    static {
        SERVER_MAP.put(AAM, "/ib-base");
        SERVER_MAP.put(ATDM, "/ib-base");
        SERVER_MAP.put(ATMC, "/ib-taskmap");
        SERVER_MAP.put(AUDC, "/ib-base");
        SERVER_MAP.put(UIBOT, "/ib-uirender");
        SERVER_MAP.put(IM, "/ip-im");
        SERVER_MAP.put(KNOWLEDGEGRAPH, "/ib-knowledgegraph");
        SERVER_MAP.put(TASKENGINE, "/ip-taskengine");
        SERVER_MAP.put(TDD, "/ib-deliverydesigner");
        SERVER_MAP.put(PTM, "/ib-taskmap");
        SERVER_MAP.put(APPMETADATA, "/ip-appmetadata");
        SERVER_MAP.put(IMPORTEXPORT, "/ib-importexport");
    }

    /**
     * 转换
     * @param urlSetting 后端服务配置
     * @return 前端服务配置
     */
    public static DigiwinApiUrlSetting convert(DigiwinApiUrlSetting urlSetting) {
        // 重置url，构建网关url
        urlSetting.setAamUrl(buildGatewayUrl(AAM));
        urlSetting.setAtdmUrl(buildGatewayUrl(ATDM));
        urlSetting.setAtmcUrl(buildGatewayUrl(ATMC));
        urlSetting.setAudcUrl(buildGatewayUrl(AUDC));
        urlSetting.setUibotUrl(buildGatewayUrl(UIBOT));
        urlSetting.setImUrl(buildGatewayUrl(IM));
        urlSetting.setKnowledgeMapsUrl(buildGatewayUrl(KNOWLEDGEGRAPH));
        urlSetting.setTaskEngineUrl(buildGatewayUrl(TASKENGINE));
        urlSetting.setTddUrl(buildGatewayUrl(TDD));
        urlSetting.setPtmUrl(buildGatewayUrl(PTM));
        urlSetting.setAppmetadataUrl(buildGatewayUrl(APPMETADATA));
        urlSetting.setImportexportUrl(buildGatewayUrl(IMPORTEXPORT));

        // wjw FIXME: 2025/7/22 后端改造Url只配置了域名，故之前前端使用的Url需不变（高级属性中可能已使用此Url配置）
        urlSetting.setKnowledgeMapsUrl(urlSetting.getKnowledgeMapsUrl() + "/restful/service");
        urlSetting.setThemeMapUrl(urlSetting.getThemeMapUrl() + "/restful/service");
        urlSetting.setTaskEngineUrl(urlSetting.getTaskEngineUrl() + "/restful/standard/taskengine");
        return urlSetting;
    }

    /**
     * 构建网关URL
     * @param serviceKey 服务键
     * @return 完整的网关URL
     */
    private static String buildGatewayUrl(String serviceKey) {
        return AppContext.getApiUrlSetting().getGatewayUrl() + API_PREFIX + SERVER_MAP.get(serviceKey);
    }
}
